/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.effects.EffDelay;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public abstract class TriggerSection
extends TriggerItem {
    private List<TriggerItem> items;
    private boolean stopped = false;
    private final boolean stopParentOnFalseCondition;
    private static final String indent = "  ";
    private static String indentation = "  ";

    protected static void incIndentation() {
        indentation = String.valueOf(indentation) + indent;
    }

    protected static void decIndentation() {
        indentation = indentation.substring(indentation.length() - indent.length());
    }

    protected TriggerSection(List<TriggerItem> items, boolean stopParentOnFalseCondition) {
        this.setTriggerItems(items);
        this.stopParentOnFalseCondition = stopParentOnFalseCondition;
    }

    protected TriggerSection(SectionNode node, boolean stopParentOnFalseCondition) {
        ScriptLoader.currentSections.add(this);
        this.setTriggerItems(ScriptLoader.loadItems(node));
        ScriptLoader.currentSections.remove(ScriptLoader.currentSections.size() - 1);
        this.stopParentOnFalseCondition = stopParentOnFalseCondition;
    }

    protected TriggerSection(boolean stopParentOnFalseCondition) {
        this.stopParentOnFalseCondition = stopParentOnFalseCondition;
    }

    protected void setTriggerItems(List<TriggerItem> items) {
        this.items = items;
        for (TriggerItem item : items) {
            item.setParent(this);
        }
    }

    @Override
    public abstract boolean run(Event var1);

    protected void run(Event e, boolean run) {
        if (Skript.debug() && !(this instanceof Trigger)) {
            Skript.info(String.valueOf(indentation) + (run ? "" : "-") + this.toString(e, true) + ":");
        }
        if (!run) {
            return;
        }
        this.run(e, 0);
    }

    private final void run(final Event e, int start) {
        this.stopped = false;
        if (Skript.debug() && !(this instanceof Trigger)) {
            TriggerSection.incIndentation();
        }
        int j = start;
        while (j < this.items.size()) {
            boolean ok;
            TriggerItem i = this.items.get(j);
            if (i instanceof EffDelay) {
                int d = ((EffDelay)i).getDelay(e);
                boolean bl = ok = d != -1;
                if (ok) {
                    final int newStart = j + 1;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            TriggerSection.this.run(e, newStart);
                        }
                    }, (long)d);
                }
            } else {
                ok = i.run(e);
            }
            if (Skript.debug() && !(i instanceof TriggerSection)) {
                if (!this.stopped) {
                    Skript.info(String.valueOf(indentation) + (ok ? "" : "-") + i.toString(e, true));
                } else {
                    Skript.info(String.valueOf(indentation) + "#" + i.toString(e, true));
                }
            }
            if (!ok && this.stopParentOnFalseCondition) {
                this.getParent().stop();
            }
            if (this.stopped || !ok || i instanceof EffDelay) break;
            ++j;
        }
        if (Skript.debug() && !(this instanceof Trigger)) {
            TriggerSection.decIndentation();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

