/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprXOfItem
extends SimpleExpression<ItemStack> {
    private int amount;
    private Expression<ItemStack> items;

    static {
        Skript.registerExpression(ExprXOfItem.class, ItemStack.class, Skript.ExpressionType.PROPERTY, "<\\d+> of %itemstacks%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        if (this.items instanceof Literal) {
            return false;
        }
        this.amount = Integer.parseInt(parseResult.regexes.get(0).group());
        return true;
    }

    @Override
    public boolean isSingle() {
        return this.items.isSingle();
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    protected ItemStack[] get(Event e) {
        ItemStack[] iss;
        ItemStack[] itemStackArray = iss = this.items.getArray(e);
        int n = iss.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack is = itemStackArray[n2];
            is.setAmount(this.amount);
            ++n2;
        }
        return iss;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.amount) + " of " + this.items.toString(e, debug);
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

