/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.WeatherType;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class ExprWeather
extends PropertyExpression<World, WeatherType> {
    private Expression<World> worlds;
    private boolean delayed;

    static {
        Skript.registerExpression(ExprWeather.class, WeatherType.class, Skript.ExpressionType.PROPERTY, "[the] weather [(in|of) %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.worlds = vars[0];
        this.setExpr(this.worlds);
        this.delayed = isDelayed;
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the weather in " + this.worlds.toString(e, debug);
    }

    protected WeatherType[] get(Event e, World[] source) {
        if (!this.delayed && this.getTime() >= 0 && (e instanceof WeatherChangeEvent || e instanceof ThunderChangeEvent) && this.worlds.isDefault()) {
            if (e instanceof WeatherChangeEvent) {
                if (!((WeatherChangeEvent)e).toWeatherState()) {
                    return new WeatherType[]{WeatherType.CLEAR};
                }
                return new WeatherType[]{((WeatherChangeEvent)e).getWorld().isThundering() ? WeatherType.THUNDER : WeatherType.RAIN};
            }
            if (((ThunderChangeEvent)e).toThunderState()) {
                return new WeatherType[]{WeatherType.THUNDER};
            }
            return new WeatherType[]{((ThunderChangeEvent)e).getWorld().hasStorm() ? WeatherType.RAIN : WeatherType.CLEAR};
        }
        return this.get(source, new Getter<WeatherType, World>(){

            @Override
            public WeatherType get(World w) {
                return WeatherType.fromWorld(w);
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return WeatherType.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        block6: {
            WeatherType t;
            block4: {
                block5: {
                    WeatherType weatherType = t = mode == Changer.ChangeMode.CLEAR ? WeatherType.CLEAR : (WeatherType)((Object)delta);
                    if (this.delayed || this.getTime() < 0 || !(e instanceof WeatherChangeEvent) && !(e instanceof ThunderChangeEvent) || !this.worlds.isDefault()) break block4;
                    if (!(e instanceof WeatherChangeEvent)) break block5;
                    if (((WeatherChangeEvent)e).toWeatherState() && t == WeatherType.CLEAR) {
                        ((WeatherChangeEvent)e).setCancelled(true);
                    }
                    if (((WeatherChangeEvent)e).getWorld().isThundering() != (t == WeatherType.THUNDER)) {
                        ((WeatherChangeEvent)e).getWorld().setThundering(t == WeatherType.THUNDER);
                    }
                    break block6;
                }
                if (((ThunderChangeEvent)e).toThunderState() && t != WeatherType.THUNDER) {
                    ((ThunderChangeEvent)e).setCancelled(true);
                }
                if (((ThunderChangeEvent)e).getWorld().hasStorm() == (t != WeatherType.CLEAR)) break block6;
                ((ThunderChangeEvent)e).getWorld().setStorm(t != WeatherType.CLEAR);
                break block6;
            }
            World[] worldArray = this.worlds.getArray(e);
            int n = worldArray.length;
            int n2 = 0;
            while (n2 < n) {
                World w = worldArray[n2];
                t.setWeather(w);
                ++n2;
            }
        }
    }

    @Override
    public Class<WeatherType> getReturnType() {
        return WeatherType.class;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.worlds, WeatherChangeEvent.class, ThunderChangeEvent.class);
    }
}

