/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ExprTool
extends PropertyExpression<Player, Slot> {
    private Expression<Player> players;
    private boolean delayed;

    static {
        Skript.registerExpression(ExprTool.class, Slot.class, Skript.ExpressionType.PROPERTY, "[the] (tool|held item) [of %players%]", "%player%'[s] (tool|held item)");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.setExpr(this.players);
        this.delayed = isDelayed;
        return true;
    }

    protected Slot[] get(final Event e, Player[] source) {
        if (!this.delayed && e instanceof PlayerItemHeldEvent && this.players.isDefault()) {
            return new Slot[]{new Slot((Inventory)((PlayerItemHeldEvent)e).getPlayer().getInventory(), this.getTime() >= 0 ? ((PlayerItemHeldEvent)e).getNewSlot() : ((PlayerItemHeldEvent)e).getPreviousSlot())};
        }
        if (!this.delayed && e instanceof PlayerBucketEvent && this.players.isDefault()) {
            return new Slot[]{new Slot((Inventory)((PlayerBucketEvent)e).getPlayer().getInventory(), ((PlayerBucketEvent)e).getPlayer().getInventory().getHeldItemSlot()){

                @Override
                public ItemStack getItem() {
                    return ExprTool.this.getTime() <= 0 ? super.getItem() : ((PlayerBucketEvent)e).getItemStack();
                }

                @Override
                public void setItem(ItemStack item) {
                    if (ExprTool.this.getTime() >= 0) {
                        ((PlayerBucketEvent)e).setItemStack(item);
                    } else {
                        super.setItem(item);
                    }
                }
            }};
        }
        return this.get(source, new Getter<Slot, Player>(){

            @Override
            public Slot get(final Player p) {
                return new Slot((Inventory)p.getInventory(), p.getInventory().getHeldItemSlot()){

                    @Override
                    public void setItem(ItemStack item) {
                        p.setItemInHand(item);
                    }

                    @Override
                    public ItemStack getItem() {
                        return p.getItemInHand();
                    }

                    @Override
                    public String toString(Event e, boolean debug) {
                        return String.valueOf(ExprTool.this.getTime() == 1 ? "future " : (ExprTool.this.getTime() == -1 ? "former " : "")) + "tool of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the " + (this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.players.toString(e, debug);
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.players, PlayerItemHeldEvent.class, PlayerBucketFillEvent.class, PlayerBucketEmptyEvent.class);
    }
}

