/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import java.util.ArrayList;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class ExprTarget
extends PropertyExpression<LivingEntity, Entity> {
    private Expression<EntityData<?>> types;
    private Expression<LivingEntity> entities;

    static {
        Skript.registerExpression(ExprTarget.class, Entity.class, Skript.ExpressionType.NORMAL, "[the] target[[ed] %entitydatas%] [of %livingentities%]", "%livingentities%'[s] target[[ed] %entitydatas%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.types = vars[matchedPattern];
        this.entities = vars[1 - matchedPattern];
        this.setExpr(this.entities);
        return true;
    }

    protected Entity[] get(Event evt, LivingEntity[] source) {
        ArrayList<Entity> targets = new ArrayList<Entity>();
        EntityData<?>[] types = this.types.getAll(evt);
        LivingEntity[] livingEntityArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity e = livingEntityArray[n2];
            EntityData<?>[] entityDataArray = types;
            int n3 = types.length;
            int n4 = 0;
            while (n4 < n3) {
                EntityData<?> type = entityDataArray[n4];
                Entity t = Utils.getTargetEntity(e, type.getType());
                if (t != null) {
                    targets.add(t);
                }
                ++n4;
            }
            ++n2;
        }
        return targets.toArray(new Entity[0]);
    }

    @Override
    public Class<Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the targeted " + this.types.toString(e, debug) + " of " + this.entities.toString(e, debug);
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return LivingEntity.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        LivingEntity target = (LivingEntity)delta;
        LivingEntity[] livingEntityArray = this.entities.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity entity = livingEntityArray[n2];
            if (entity instanceof Creature) {
                ((Creature)entity).setTarget(target);
            }
            ++n2;
        }
    }
}

