/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import java.util.Random;
import org.bukkit.event.Event;

public class ExprRandom
extends SimpleExpression<Number> {
    private Expression<Double> lower;
    private Expression<Double> upper;
    private final Random rand = new Random();
    private boolean integer;

    static {
        Skript.registerExpression(ExprRandom.class, Number.class, Skript.ExpressionType.NORMAL, "[a] random number between %double% and %double%", "[a] random integer between %double% and %double%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.lower = vars[0];
        this.upper = vars[1];
        this.integer = matchedPattern == 1;
        return true;
    }

    protected Number[] get(Event e) {
        Double l = this.lower.getSingle(e);
        Double u = this.upper.getSingle(e);
        if (u == null || l == null) {
            return null;
        }
        if (this.integer) {
            return new Integer[]{(int)(Math.ceil(l) + (double)this.rand.nextInt((int)(Math.floor(u) - Math.ceil(l) + 1.0)))};
        }
        return new Double[]{l + this.rand.nextDouble() * (u - l)};
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.integer ? Integer.class : Double.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "a random number between " + this.lower + " and " + this.upper;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

