/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Offset;
import ch.njol.util.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprLightLevel
extends PropertyExpression<Block, Byte> {
    private Expression<Block> blocks;
    private Expression<Offset> offset;
    private final int SKY = 1;
    private final int BLOCK = 2;
    private final int ANY = 3;
    private int whatLight = 3;

    static {
        Skript.registerExpression(ExprLightLevel.class, Byte.class, Skript.ExpressionType.PROPERTY, "[(sky|block)[ ]]light[]level (of|%offset%) %block%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        this.offset = exprs[0];
        this.blocks = exprs[1];
        if (StringUtils.startsWithIgnoreCase(parseResult.expr, "sky")) {
            this.whatLight = 1;
        } else if (StringUtils.startsWithIgnoreCase(parseResult.expr, "block")) {
            this.whatLight = 2;
        }
        return false;
    }

    @Override
    public Class<Byte> getReturnType() {
        return Byte.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "light level " + this.offset.toString(e, debug) + " " + this.blocks.toString(e, debug);
    }

    protected Byte[] get(Event e, Block[] source) {
        final Offset o = this.offset.getSingle(e);
        if (o == null) {
            return null;
        }
        return this.get(source, new Converter<Block, Byte>(){

            @Override
            public Byte convert(Block b) {
                return ExprLightLevel.this.whatLight == 3 ? o.getRelative(b).getLightLevel() : (ExprLightLevel.this.whatLight == 2 ? o.getRelative(b).getLightFromBlocks() : o.getRelative(b).getLightFromSky());
            }
        });
    }
}

