/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import java.util.ArrayList;
import org.bukkit.event.Event;

public class ExprIdOf
extends PropertyExpression<ItemType, Integer> {
    private Expression<ItemType> types;
    private boolean single = false;

    static {
        Skript.registerExpression(ExprIdOf.class, Integer.class, Skript.ExpressionType.PROPERTY, "[the] id[<s>] of %itemtype%", "%itemtype%'[s] id[<s>]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.types = vars[0];
        this.setExpr(this.types);
        if (parser.regexes.isEmpty()) {
            this.single = true;
            if (!this.types.isSingle() || this.types instanceof Literal && ((ItemType)((Literal)this.types).getSingle()).getTypes().size() != 1) {
                Skript.warning("'" + this.types + "' has multiple ids");
                this.single = false;
            }
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the id" + (this.single ? "" : "s") + " of " + this.types.toString(e, debug);
    }

    protected Integer[] get(Event e, ItemType[] source) {
        if (this.single) {
            ItemType t = this.types.getSingle(e);
            if (t == null) {
                return null;
            }
            return new Integer[]{t.getTypes().get(0).getId()};
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        ItemType[] itemTypeArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            for (ItemData d : t) {
                r.add(d.getId());
            }
            ++n2;
        }
        return r.toArray(new Integer[0]);
    }

    @Override
    public Class<Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public boolean canLoop() {
        return !this.single;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("id");
    }
}

