/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;

public class ExprFacing
extends PropertyExpression<Object, BlockFace> {
    private boolean horizontal;

    static {
        Skript.registerExpression(ExprFacing.class, BlockFace.class, Skript.ExpressionType.PROPERTY, "[the] facing of %livingentity/block%", "%block/livingentity%'[s] facing", "[the] horizontal facing of %livingentity/block%", "%block/livingentity%'[s] horizontal facing");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.horizontal = matchedPattern >= 2;
        return true;
    }

    protected BlockFace[] get(final Event e, Object[] source) {
        return this.get(source, new Converter<Object, BlockFace>(){

            @Override
            public BlockFace convert(Object o) {
                if (o instanceof Block) {
                    MaterialData d = ((Block)o).getType().getNewData(((Block)o).getData());
                    if (d instanceof Directional) {
                        return ((Directional)d).getFacing();
                    }
                    return null;
                }
                if (e instanceof LivingEntity) {
                    return Utils.getFacing(((LivingEntity)e).getLocation(), ExprFacing.this.horizontal);
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        });
    }

    @Override
    public Class<BlockFace> getReturnType() {
        return BlockFace.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "facing of " + this.getExpr();
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (!Block.class.isAssignableFrom(this.getExpr().getReturnType())) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET) {
            return BlockFace.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Block b = (Block)this.getExpr().getSingle(e);
        if (b == null) {
            return;
        }
        MaterialData d = b.getType().getNewData(b.getData());
        if (!(d instanceof Directional)) {
            return;
        }
        ((Directional)d).setFacingDirection((BlockFace)delta);
        b.setData(d.getData());
    }
}

