/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Slot;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprDurability
extends PropertyExpression<ItemStack, Short> {
    private Expression<ItemStack> types;
    private Expression<? extends Slot> slots = null;

    static {
        Skript.registerExpression(ExprDurability.class, Short.class, Skript.ExpressionType.PROPERTY, "[the] ((data|damage)[s] [value[s]]|durabilit(y|ies)) of %itemstacks%", "%itemstacks%'[s] ((data|damage)[s] [value[s]]|durabilit(y|ies))");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[0];
        this.setExpr(this.types);
        return true;
    }

    @Override
    public Class<Short> getReturnType() {
        return Short.class;
    }

    protected Short[] get(Event e, ItemStack[] source) {
        return this.get(source, new Converter<ItemStack, Short>(){

            @Override
            public Short convert(ItemStack is) {
                return is.getDurability();
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "data of " + this.types.toString(e, debug);
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        this.slots = this.types.getConvertedExpression(Slot.class);
        if (this.slots != null) {
            return Integer.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int a = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            a = (Integer)delta;
        }
        switch (mode) {
            case REMOVE: {
                a = -a;
            }
            case ADD: {
                Slot[] slotArray = this.slots.getArray(e);
                int n = slotArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot slot = slotArray[n2];
                    ItemStack item = slot.getItem();
                    item.setDurability((short)(item.getDurability() + a));
                    slot.setItem(item);
                    ++n2;
                }
                break;
            }
            case CLEAR: {
                a = 0;
            }
            case SET: {
                Slot[] slotArray = this.slots.getArray(e);
                int n = slotArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Slot slot = slotArray[n3];
                    ItemStack item = slot.getItem();
                    item.setDurability((short)a);
                    slot.setItem(item);
                    ++n3;
                }
                break;
            }
        }
    }
}

