/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class ExprDrops
extends SimpleExpression<ItemStack> {
    private boolean delayed;

    static {
        Skript.registerExpression(ExprDrops.class, ItemStack.class, Skript.ExpressionType.SIMPLE, "[the] drops");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        if (!Utils.contains(ScriptLoader.currentEvents, EntityDeathEvent.class)) {
            Skript.error("'drops' can only be used in death events");
            return false;
        }
        this.delayed = isDelayed;
        return true;
    }

    protected ItemStack[] get(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return null;
        }
        return ((EntityDeathEvent)e).getDrops().toArray(new ItemStack[0]);
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (this.delayed) {
            return null;
        }
        return ItemType[].class;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (!(e instanceof EntityDeathEvent)) {
            return;
        }
        List drops = ((EntityDeathEvent)e).getDrops();
        switch (mode) {
            case SET: {
                drops.clear();
            }
            case ADD: {
                ItemType[] itemTypeArray = (ItemType[])delta;
                int n = itemTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemType i = itemTypeArray[n2];
                    i.addTo(drops);
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                ItemType[] itemTypeArray = (ItemType[])delta;
                int n = itemTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ItemType i = itemTypeArray[n3];
                    i.removeFrom(drops);
                    ++n3;
                }
                break;
            }
            case CLEAR: {
                drops.clear();
            }
        }
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the drops";
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

