/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class ExprCoordinate
extends PropertyExpression<Location, Double> {
    private static final char[] axes;
    private int axis;

    static {
        Skript.registerExpression(ExprCoordinate.class, Double.class, Skript.ExpressionType.PROPERTY, "[the] <[xyz]>(-| )(coord[inate]|pos[ition]|loc[ation])[s] of %locations%", "%locations%'[s] <[xyz]>(-| )(coord[inate]|pos[ition]|loc[ation])[s]");
        axes = new char[]{'x', 'y', 'z'};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.axis = parseResult.regexes.get(0).group().charAt(0) - 120;
        return true;
    }

    protected Double[] get(Event e, Location[] source) {
        return this.get(source, new Converter<Location, Double>(){

            @Override
            public Double convert(Location l) {
                return ExprCoordinate.this.axis == 0 ? l.getX() : (ExprCoordinate.this.axis == 1 ? l.getY() : l.getZ());
            }
        });
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + axes[this.axis] + "-coordinate of " + this.getExpr().toString(e, debug);
    }
}

