/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.BlockLineIterator;
import ch.njol.skript.util.Offset;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprBlocks
extends SimpleExpression<Block> {
    private boolean isLoop;
    private Expression<Block> blocks;
    private Expression<Block> end;
    private Expression<Offset> offsets;
    private int matchedPattern;

    static {
        Skript.registerExpression(ExprBlocks.class, Block.class, Skript.ExpressionType.NORMAL, "[the] block[s] %offsets% [%blocks%]", "[the] blocks from %block% to %block%", "[the] blocks between %block% and %block%", "[the] blocks from %block% on %offset%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.matchedPattern = matchedPattern;
        switch (matchedPattern) {
            case 0: {
                this.offsets = vars[0];
                this.blocks = vars[1];
                this.isLoop = StringUtils.startsWithIgnoreCase(parser.expr, "blocks") || StringUtils.startsWithIgnoreCase(parser.expr, "the blocks");
                break;
            }
            case 1: 
            case 2: {
                this.blocks = vars[0];
                this.end = vars[1];
                this.isLoop = true;
                break;
            }
            case 3: {
                this.blocks = vars[0];
                this.offsets = vars[1];
                this.isLoop = true;
            }
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.end == null) {
            return "block" + (this.isSingle() ? "" : "s") + " " + this.offsets.toString(e, debug) + " " + this.blocks.toString(e, debug);
        }
        return "blocks from " + this.blocks.toString(e, debug) + " to " + this.end.toString(e, debug);
    }

    protected Block[] get(Event e) {
        if (this.matchedPattern == 0) {
            Block[] bs = this.blocks.getArray(e);
            if (this.offsets == null) {
                return bs;
            }
            return Offset.setOff(this.offsets.getArray(e), bs);
        }
        ArrayList<Block> r = new ArrayList<Block>();
        for (Block b : new IteratorIterable<Block>(this.iterator(e))) {
            r.add(b);
        }
        return r.toArray(new Block[r.size()]);
    }

    @Override
    public Iterator<Block> iterator(Event e) {
        if (this.matchedPattern == 0 && !this.isLoop) {
            return super.iterator(e);
        }
        Block b = this.blocks.getSingle(e);
        if (b == null) {
            return null;
        }
        if (this.offsets != null) {
            Offset o = this.offsets.getSingle(e);
            if (o == null) {
                return null;
            }
            return new BlockLineIterator(b, o.toVector(), 100.0);
        }
        Block b2 = this.end.getSingle(e);
        if (b2 == null || b2.getWorld() != b.getWorld()) {
            return null;
        }
        return new BlockLineIterator(b, b2);
    }

    @Override
    public boolean canLoop() {
        return this.isLoop;
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean isSingle() {
        return this.matchedPattern == 0 && this.blocks.isSingle() && this.offsets.isSingle();
    }

    @Override
    public boolean getAnd() {
        return this.matchedPattern != 0 || this.blocks.getAnd() && this.offsets.getAnd();
    }
}

