/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.StringUtils;
import org.bukkit.event.Event;

public class ExprArgument
extends SimpleExpression<Object> {
    private Argument<?> arg;

    static {
        Skript.registerExpression(ExprArgument.class, Object.class, Skript.ExpressionType.SIMPLE, "[the] last arg[ument][s]", "[the] arg[ument][s](-| )<(\\d+)>", "[the] <(\\d*1)st|(\\d*2)nd|(\\d*3)rd|(\\d*[4-90])th> arg[ument][s]", "[the] arg[ument][s]", "[the] <.+>( |-)arg[ument]", "[the] arg[ument]( |-)<.+>");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        if (Commands.currentArguments == null) {
            Skript.error("The expression 'argument' can only be used within a command");
            return false;
        }
        if (Commands.currentArguments.size() == 0) {
            Skript.error("This command doesn't allow any arguments");
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.arg = Commands.currentArguments.get(Commands.currentArguments.size() - 1);
                break;
            }
            case 1: 
            case 2: {
                int i = Integer.parseInt(parser.regexes.get(0).group(1));
                if (i > Commands.currentArguments.size()) {
                    Skript.error("the command doesn't have a " + StringUtils.fancyOrderNumber(i) + " argument");
                    return false;
                }
                this.arg = Commands.currentArguments.get(i - 1);
                break;
            }
            case 3: {
                if (Commands.currentArguments.size() == 1) {
                    this.arg = Commands.currentArguments.get(0);
                    break;
                }
                Skript.error("'argument(s)' cannot be used if the command has multiple arguments");
                return false;
            }
            case 4: 
            case 5: {
                Class<?> c = Skript.getClassFromUserInput(parser.regexes.get(0).group());
                if (c == null) {
                    return false;
                }
                for (Argument<?> a : Commands.currentArguments) {
                    if (!c.isAssignableFrom(a.getType())) continue;
                    if (this.arg != null) {
                        Skript.error("There are multiple " + Skript.getExactClassName(c) + " arguments in this command");
                        return false;
                    }
                    this.arg = a;
                }
                if (this.arg != null) break;
                Skript.error("There is no " + Skript.getExactClassName(c) + " argument in this command");
                return false;
            }
        }
        assert (this.arg != null);
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        if (!(e instanceof SkriptCommandEvent)) {
            return null;
        }
        return this.arg.getCurrent();
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.arg.getType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the " + StringUtils.fancyOrderNumber(this.arg.getIndex() + 1) + " argument";
        }
        return Skript.getDebugMessage(this.getArray(e));
    }

    @Override
    public boolean isSingle() {
        return this.arg.isSingle();
    }

    @Override
    public boolean canLoop() {
        return !this.arg.isSingle();
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("argument");
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

