/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EvtMoveOn
extends SkriptEvent {
    private static final HashMap<BlockLocation, List<Trigger>> blockTriggers = new HashMap();
    private static final HashMap<Integer, List<Trigger>> itemTypeTriggers = new HashMap();
    private ItemType[] types = null;
    private World world;
    private int x;
    private int y;
    private int z;
    private static boolean registeredExecutor = false;
    private static final EventExecutor executor = new EventExecutor(){

        public void execute(Listener l, Event event) throws EventException {
            List ts;
            PlayerMoveEvent e = (PlayerMoveEvent)event;
            Location from = e.getFrom();
            Location to = e.getTo();
            if (from.getWorld() == to.getWorld() && from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
                return;
            }
            SkriptEventHandler.logEventStart((Event)e);
            if (!blockTriggers.isEmpty() && (ts = (List)blockTriggers.get(new BlockLocation(to.getWorld(), to.getBlockX(), to.getBlockY(), to.getBlockZ()))) != null) {
                for (Trigger t : ts) {
                    SkriptEventHandler.logTriggerStart(t);
                    t.run((Event)e);
                    SkriptEventHandler.logTriggerEnd(t);
                }
            }
            if (!itemTypeTriggers.isEmpty()) {
                int id = to.getWorld().getBlockTypeIdAt(to.getBlockX(), to.getBlockY(), to.getBlockZ());
                List ts2 = (List)itemTypeTriggers.get(id);
                if (ts2 != null) {
                    byte data = to.getBlock().getData();
                    block1: for (Trigger t : ts2) {
                        EvtMoveOn se = (EvtMoveOn)t.getEvent();
                        ItemType[] itemTypeArray = se.types;
                        int n = itemTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemType i = itemTypeArray[n2];
                            if (i.isOfType(id, data)) {
                                SkriptEventHandler.logTriggerStart(t);
                                t.run((Event)e);
                                SkriptEventHandler.logTriggerEnd(t);
                                continue block1;
                            }
                            ++n2;
                        }
                    }
                }
            }
            SkriptEventHandler.logEventEnd();
        }
    };

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (parser.regexes.get(0).group().equalsIgnoreCase("<block>")) {
            return true;
        }
        Matcher m = Pattern.compile("<block:(.+)>").matcher(parser.regexes.get(0).group());
        if (m.matches()) {
            Block b = (Block)Skript.deserialize("block", m.group(1));
            if (b == null) {
                return false;
            }
            this.world = b.getWorld();
            this.x = b.getX();
            this.y = b.getY();
            this.z = b.getZ();
        } else {
            Literal<ItemType> l = SkriptParser.parseLiteral(parser.regexes.get(0).group(), ItemType.class, ParseContext.EVENT);
            if (l == null) {
                return false;
            }
            ItemType[] itemTypeArray = this.types = l.getAll();
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                boolean hasBlock = false;
                for (ItemData d : t) {
                    if (d.getId() == -1) {
                        Skript.error("Can't use an 'on walk' event with an alias that matches all blocks");
                        return false;
                    }
                    if (d.getId() > 255) continue;
                    hasBlock = true;
                }
                if (!hasBlock) {
                    Skript.error(t + " is not a block and can thus not be walked on");
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "walk on " + (this.types != null ? Skript.toString(this.types, false) : "<block:" + this.world.getName() + ":" + this.x + "," + this.y + "," + this.z + ">");
    }

    @Override
    public boolean check(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(Trigger trigger) {
        if (this.types == null) {
            BlockLocation l = new BlockLocation(this.world, this.x, this.y, this.z);
            List<Trigger> ts = blockTriggers.get(l);
            if (ts == null) {
                ts = new ArrayList<Trigger>();
                blockTriggers.put(l, ts);
            }
            ts.add(trigger);
        } else {
            ItemType[] itemTypeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                for (ItemData d : t) {
                    if (d.getId() > 255) continue;
                    List<Trigger> ts = itemTypeTriggers.get(d.getId());
                    if (ts == null) {
                        ts = new ArrayList<Trigger>();
                        itemTypeTriggers.put(d.getId(), ts);
                    }
                    ts.add(trigger);
                }
                ++n2;
            }
        }
        if (!registeredExecutor) {
            Bukkit.getPluginManager().registerEvent(PlayerMoveEvent.class, new Listener(){}, Skript.getPriority(), executor, (Plugin)Skript.getInstance(), true);
            registeredExecutor = true;
        }
    }

    @Override
    public void unregister() {
        blockTriggers.clear();
        itemTypeTriggers.clear();
    }

    private static final class BlockLocation {
        final World world;
        final int x;
        final int y;
        final int z;

        BlockLocation(World world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BlockLocation)) {
                return false;
            }
            BlockLocation other = (BlockLocation)obj;
            return this.world == other.world && this.x == other.x && this.y == other.y && this.z == other.z;
        }

        public int hashCode() {
            return this.world.hashCode() + 29 * (this.x + 17 * (this.y + 31 * this.z));
        }
    }
}

