/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;

public class XpOrbData
extends EntityData<ExperienceOrb> {
    private int xp = -1;
    private boolean plural;

    static {
        XpOrbData.register(XpOrbData.class, "xporb", ExperienceOrb.class, "([e]xp|experience)( |-)orb[s]", "<\\d+> ([e]xp|experience)");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1) {
            this.xp = Integer.parseInt(parseResult.regexes.get(0).group());
        }
        this.plural = parseResult.expr.endsWith("s");
        return true;
    }

    @Override
    protected void set(ExperienceOrb entity) {
        if (this.xp != -1) {
            entity.setExperience(this.xp);
        }
    }

    @Override
    protected boolean match(ExperienceOrb entity) {
        return this.xp == -1 || entity.getExperience() == this.xp;
    }

    @Override
    public Class<? extends ExperienceOrb> getType() {
        return ExperienceOrb.class;
    }

    @Override
    public String toString() {
        return "experience orb";
    }

    @Override
    public ExperienceOrb spawn(Location loc) {
        ExperienceOrb orb = (ExperienceOrb)super.spawn(loc);
        if (this.xp == -1) {
            orb.setExperience(1);
        }
        return orb;
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }
}

