/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import org.bukkit.Location;
import org.bukkit.entity.Villager;

public class VillagerData
extends EntityData<Villager> {
    private Villager.Profession profession = null;
    private boolean plural;

    static {
        VillagerData.register(VillagerData.class, "villager", Villager.class, "villager[s]", "farmer[s]", "librarian[s]", "priest[s]", "[black]smith[s]", "butcher[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.profession = Villager.Profession.getProfession((int)(matchedPattern - 1));
        }
        this.plural = parseResult.expr.endsWith("s");
        return true;
    }

    @Override
    protected void set(Villager entity) {
        if (this.profession != null) {
            entity.setProfession(this.profession);
        }
    }

    @Override
    public Villager spawn(Location loc) {
        Villager v = (Villager)super.spawn(loc);
        if (this.profession == null) {
            v.setProfession(Utils.getRandom(Villager.Profession.values()));
        }
        return v;
    }

    @Override
    protected boolean match(Villager entity) {
        return this.profession == null || entity.getProfession() == this.profession;
    }

    @Override
    public Class<? extends Villager> getType() {
        return Villager.class;
    }

    @Override
    public String toString() {
        return this.profession == null ? "villager" : this.profession.toString().toLowerCase();
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }
}

