/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;

public class MinecartData
extends EntityData<Minecart> {
    private MinecartType type = MinecartType.ANY;
    private boolean plural;

    static {
        MinecartData.register(MinecartData.class, "minecart", Minecart.class, MinecartType.patterns);
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.type = MinecartType.byPattern[matchedPattern];
        this.plural = parseResult.expr.endsWith("s");
        return true;
    }

    @Override
    public void set(Minecart entity) {
    }

    @Override
    public boolean match(Minecart entity) {
        if (this.type == MinecartType.NORMAL) {
            return !(entity instanceof PoweredMinecart) && !(entity instanceof StorageMinecart);
        }
        return this.type.c.isInstance(entity);
    }

    @Override
    public Class<? extends Minecart> getType() {
        return this.type.c;
    }

    @Override
    public String toString() {
        return this.type.name;
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    private static enum MinecartType {
        ANY(Minecart.class, "minecart", "[mine]cart[s]"),
        NORMAL(Minecart.class, "regular minecart", "(normal|regular) [mine]cart[s]"),
        STORAGE(StorageMinecart.class, "storage minecart", "storage [mine]cart[s]"),
        POWERED(PoweredMinecart.class, "powered minecart", "powered [mine]cart[s]");

        final Class<? extends Minecart> c;
        final String name;
        final String pattern;
        static String[] patterns;
        static MinecartType[] byPattern;

        static {
            patterns = new String[MinecartType.values().length];
            byPattern = MinecartType.values();
            int i = 0;
            while (i < byPattern.length) {
                MinecartType.patterns[i] = MinecartType.byPattern[i].pattern;
                ++i;
            }
        }

        private MinecartType(Class<? extends Minecart> c, String name, String pattern) {
            this.c = c;
            this.name = name;
            this.pattern = pattern;
        }
    }
}

