/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.entity.SimpleEntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Validate;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class EntityData<E extends Entity>
implements SyntaxElement {
    private static final List<EntityDataInfo<?>> infos = new ArrayList();

    static {
        Skript.registerClass(new ClassInfo<EntityData>(EntityData.class, "entitydata", "entity type").user("entity ?types?", "entit(y|ies)").defaultExpression(new SimpleLiteral<SimpleEntityData>(new SimpleEntityData(Entity.class), true)).parser((Parser<SimpleEntityData>)new Parser<EntityData>(){

            @Override
            public String toString(EntityData d) {
                return d.toString();
            }

            @Override
            public EntityData parse(String s, ParseContext context) {
                return EntityData.parse(s);
            }

            @Override
            public String toCodeString(EntityData o) {
                return "entitydata:" + o.toString();
            }
        }));
    }

    static <E extends Entity, T extends EntityData<E>> void register(Class<T> dataClass, String name, Class<E> entityClass, String ... patterns) {
        EntityDataInfo<T> info = new EntityDataInfo<T>(dataClass, name, entityClass, patterns);
        int i = 0;
        while (i < infos.size()) {
            if (EntityData.infos.get((int)i).entityClass.isAssignableFrom(entityClass)) {
                infos.add(i, info);
                return;
            }
            ++i;
        }
        infos.add(info);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        return this.init((Literal[])Arrays.copyOf(exprs, exprs.length, Literal[].class), matchedPattern, parseResult);
    }

    public static final EntityData<?> parse(String s) {
        String lower = s.toLowerCase();
        if (lower.startsWith("a ")) {
            s = s.substring(2);
        } else if (lower.startsWith("an ")) {
            s = s.substring(3);
        } else if (lower.startsWith("any ")) {
            s = s.substring(4);
        }
        return (EntityData)SkriptParser.parseStatic(s, infos.iterator(), null);
    }

    public static final EntityData<?> parseWithoutAnOrAny(String s) {
        return (EntityData)SkriptParser.parseStatic(s, infos.iterator(), s);
    }

    public E spawn(Location loc) {
        Validate.notNull((Object)loc, "loc");
        try {
            Entity e = loc.getWorld().spawn(loc, this.getType());
            this.set(e);
            return (E)e;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public E[] getAll(World ... worlds) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        World[] worldArray = worlds;
        int n = worlds.length;
        int n2 = 0;
        while (n2 < n) {
            World w = worldArray[n2];
            for (Entity e : w.getEntitiesByClass(this.getType())) {
                if (!this.match(e)) continue;
                list.add(e);
            }
            ++n2;
        }
        return list.toArray((Entity[])Array.newInstance(this.getType(), list.size()));
    }

    public static final <E extends Entity> E[] getAll(EntityData<?>[] types, Class<E> type, World[] worlds) {
        if (worlds == null && type == Player.class) {
            return Bukkit.getOnlinePlayers();
        }
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (worlds == null) {
            worlds = Bukkit.getWorlds().toArray(new World[0]);
        }
        World[] worldArray = worlds;
        int n = worlds.length;
        int n2 = 0;
        while (n2 < n) {
            World w = worldArray[n2];
            block1: for (Entity e : w.getEntitiesByClass(type)) {
                EntityData<?>[] entityDataArray = types;
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    EntityData<?> t = entityDataArray[n4];
                    if (t.isInstance(e)) {
                        list.add(e);
                        continue block1;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return list.toArray((Entity[])Array.newInstance(type, list.size()));
    }

    public static <E extends Entity> EntityData<? super E> fromClass(Class<E> c) {
        for (EntityDataInfo<?> info : infos) {
            if (info.entityClass == Entity.class || !info.entityClass.isAssignableFrom(c)) continue;
            try {
                return (EntityData)info.c.newInstance();
            }
            catch (Exception e) {
                assert (false);
                return null;
            }
        }
        return new SimpleEntityData(c);
    }

    public static <E extends Entity> EntityData<? super E> fromEntity(E e) {
        return EntityData.fromClass(e.getClass());
    }

    public static final String toString(Entity e) {
        return EntityData.fromEntity(e).toString();
    }

    public static final String toString(Class<? extends Entity> c) {
        return EntityData.fromClass(c).toString();
    }

    public boolean isInstance(Entity e) {
        return this.getType().isInstance(e) && this.match(e);
    }

    protected abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3);

    protected abstract void set(E var1);

    protected abstract boolean match(E var1);

    public abstract Class<? extends E> getType();

    public abstract String toString();

    public abstract boolean isPlural();

    private static final class EntityDataInfo<T extends EntityData<?>>
    extends SyntaxElementInfo<T> {
        final String codeName;
        final Class<? extends Entity> entityClass;

        public EntityDataInfo(Class<T> dataClass, String codeName, Class<? extends Entity> entityClass, String[] patterns) {
            super(patterns, dataClass);
            this.codeName = codeName;
            this.entityClass = entityClass;
        }
    }
}

