/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerRespawnEvent;

public class EffTeleport
extends Effect {
    private Expression<Entity> entities;
    private Expression<Location> location;
    private boolean delayed;

    static {
        Skript.registerEffect(EffTeleport.class, "teleport %entities% to %location%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.location = vars[1];
        this.delayed = isDelayed;
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "teleport " + this.entities.toString(e, debug) + " to " + this.location.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        Location to = this.location.getSingle(e);
        if (to == null) {
            return;
        }
        Block on = to.getBlock().getRelative(BlockFace.DOWN);
        if (Math.abs(to.getX() - (double)to.getBlockX() - 0.5) < 1.0E-10 && Math.abs(to.getZ() - (double)to.getBlockZ() - 0.5) < 1.0E-10 && on.getType() != Material.AIR) {
            to.setY((double)on.getY() + Utils.getBlockHeight(on.getType()));
        }
        if (!this.delayed && e instanceof PlayerRespawnEvent && this.entities.isDefault()) {
            ((PlayerRespawnEvent)e).setRespawnLocation(to);
            return;
        }
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (to.getYaw() == 0.0f && to.getPitch() == 0.0f) {
                Location loc = to.clone();
                loc.setPitch(entity.getLocation().getPitch());
                loc.setYaw(entity.getLocation().getYaw());
                loc.getChunk().load();
                entity.teleport(loc);
            } else {
                to.getChunk().load();
                entity.teleport(to);
            }
            ++n2;
        }
    }
}

