/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;

public class EffShoot
extends Effect {
    private static final double DEFAULT_SPEED = 5.0;
    private Expression<EntityData<?>> types;
    private Expression<LivingEntity> shooters;
    private Expression<Double> velocity;

    static {
        Skript.registerEffect(EffShoot.class, "shoot %entitydatas% [from %livingentity%] [(at|with) (speed|velocity) %-double%]", "(make|let) %livingentity% shoot %entitydatas% [(at|with) (speed|velocity) %-double%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[matchedPattern];
        this.shooters = exprs[1 - matchedPattern];
        this.velocity = exprs[2 - matchedPattern];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Double v = this.velocity == null ? 5.0 : this.velocity.getSingle(e);
        if (v == null) {
            return;
        }
        LivingEntity[] livingEntityArray = this.shooters.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity shooter = livingEntityArray[n2];
            EntityData<?>[] entityDataArray = this.types.getArray(e);
            int n3 = entityDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object projectile;
                EntityData<?> d = entityDataArray[n4];
                if (Projectile.class.isAssignableFrom(d.getType())) {
                    projectile = shooter.launchProjectile(d.getType());
                    if (this.velocity != null) {
                        projectile.setVelocity(projectile.getVelocity().normalize().multiply(v.doubleValue()));
                    }
                } else {
                    projectile = d.spawn(shooter.getEyeLocation());
                    projectile.setVelocity(shooter.getLocation().getDirection().multiply(v.doubleValue()));
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "shoot " + this.types.toString(e, debug) + " from " + this.shooters.toString(e, debug);
    }
}

