/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerSection;
import org.bukkit.event.Event;

public class EffExit
extends Effect {
    private int breakLevels;

    static {
        Skript.registerEffect(EffExit.class, "(exit|stop) [trigger]", "(exit|stop) [1] section", "(exit|stop) <\\d+> sections", "(exit|stop) all sections");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, boolean isDelayed, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: {
                this.breakLevels = ScriptLoader.currentSections.size() + 1;
                break;
            }
            case 1: 
            case 2: {
                int n = this.breakLevels = matchedPattern == 1 ? 1 : Integer.parseInt(parser.regexes.get(0).group());
                if (this.breakLevels <= ScriptLoader.currentSections.size()) break;
                if (ScriptLoader.currentSections.isEmpty()) {
                    Skript.error("can't exit any sections as there are no sections present");
                    return false;
                }
                Skript.error("can't exit " + this.breakLevels + " sections as there are only " + ScriptLoader.currentSections.size() + " sections present");
                return false;
            }
            case 3: {
                this.breakLevels = ScriptLoader.currentSections.size();
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        TriggerSection item = this.getParent();
        int i = 0;
        while (i < this.breakLevels && item != null) {
            item.stop();
            item = item.getParent();
            ++i;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "exit " + this.breakLevels + " sections";
    }
}

