/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.ConfigNodeIterator;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.InvalidNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.ParseOptionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.config.VoidNode;
import ch.njol.skript.config.validate.SectionValidator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SectionNode
extends Node
implements Iterable<Node> {
    private final ArrayList<Node> nodes = new ArrayList();

    public SectionNode(String name, SectionNode parent, ConfigReader r) {
        super(name, parent, r);
    }

    SectionNode(Config c) {
        super(c);
    }

    public SectionNode(String name, SectionNode parent, String orig, int lineNum) {
        super(parent.getConfig(), name, orig, lineNum);
    }

    @Override
    public Iterator<Node> iterator() {
        return new ConfigNodeIterator(this, false);
    }

    public final List<Node> getNodeList() {
        return this.nodes;
    }

    public Node get(String name) {
        for (Node node : this.nodes) {
            if (node.name == null || !node.name.equals(name)) continue;
            return node;
        }
        return null;
    }

    public int getNumVoidNodes() {
        int r = 0;
        for (Node node : this.nodes) {
            if (!(node instanceof VoidNode)) continue;
            ++r;
        }
        return r;
    }

    static final SectionNode load(Config c, ConfigReader r) throws IOException {
        return new SectionNode(c).load_i(r);
    }

    static final SectionNode load(String name, SectionNode parent, ConfigReader r) throws IOException {
        ++parent.config.level;
        SectionNode node = new SectionNode(name, parent, r).load_i(r);
        SkriptLogger.setNode(parent);
        --parent.config.level;
        return node;
    }

    private static final String readableWhitespace(String s) {
        return "'" + s.replace("\t", "->").replace(' ', '_').replaceAll("\\s", "?") + "' [-> = tab, _ = space, ? = other whitespace]";
    }

    private final SectionNode load_i(ConfigReader r) throws IOException {
        while (r.readLine() != null) {
            String s;
            SkriptLogger.setNode(this);
            String line = r.getLine().replaceFirst("(?<!#)#(?!#).*$", "").replace("##", "#");
            if (this.config.getIndentation() == null && !line.matches("\\s*") && !line.matches("\\S.*")) {
                s = line.replaceFirst("\\S.*$", "");
                if (s.matches(" +") || s.matches("\t+")) {
                    this.config.setIndentation(s);
                } else {
                    this.nodes.add(new InvalidNode(this, r));
                    Skript.error("indentation error: indent must only consist of spaces or tabs, but not mixed (found " + SectionNode.readableWhitespace(s) + ")");
                    continue;
                }
            }
            if (!line.matches("\\s*") && !line.matches("^(" + this.config.getIndentation() + "){" + this.config.level + "}\\S.*")) {
                if (line.matches("^(" + this.config.getIndentation() + "){" + this.config.level + "}\\s.*") || !line.matches("^(" + this.config.getIndentation() + ")*\\S.*")) {
                    s = line.replaceFirst("\\S.*$", "");
                    String found = s.matches(" +") || s.matches("\t+") ? String.valueOf(s.length()) + " " + (s.charAt(0) == ' ' ? "space" : "tab") + (s.length() == 1 ? "" : "s") : SectionNode.readableWhitespace(s);
                    this.nodes.add(new InvalidNode(this, r));
                    Skript.error("indentation error, expected " + this.config.level * this.config.getIndentation().length() + " " + this.config.getIndentationName() + (this.config.level * this.config.getIndentation().length() == 1 ? "" : "s") + ", found " + found);
                    continue;
                }
                if (this.nodes.isEmpty()) {
                    Skript.warning("Empty configuration section! You might want to indent one or more of the subsequent lines to make them belong to this section or remove the colon at the end of the line if you don't want this line to start a section.");
                }
                r.reset();
                return this;
            }
            if ((line = line.trim()).isEmpty()) {
                this.nodes.add(new VoidNode(this, r));
                continue;
            }
            if (line.startsWith("!") && line.indexOf(91) != -1 && line.endsWith("]")) {
                String option = line.substring(1, line.indexOf(91));
                String value = line.substring(line.indexOf(91) + 1, line.length() - 1);
                if (value.isEmpty()) {
                    this.nodes.add(new InvalidNode(this, r));
                    Skript.error("parse options must not be empty");
                    continue;
                }
                if (option.equalsIgnoreCase("separator")) {
                    if (this.config.simple) {
                        Skript.warning("scripts don't have a separator");
                        continue;
                    }
                } else {
                    InvalidNode n = new InvalidNode(this, r);
                    SkriptLogger.setNode(n);
                    this.nodes.add(n);
                    Skript.error("unknown parse option '" + option + "'");
                    continue;
                }
                this.config.separator = value;
                this.nodes.add(new ParseOptionNode(line.substring(0, line.indexOf(91)), this, r));
                continue;
            }
            if (line.endsWith(":") && (this.config.simple || line.indexOf(this.config.separator) == -1 || this.config.separator.endsWith(":") && line.indexOf(this.config.separator) == line.length() - this.config.separator.length())) {
                this.nodes.add(SectionNode.load(line.substring(0, line.length() - 1), this, r));
                continue;
            }
            if (this.config.simple) {
                this.nodes.add(new SimpleNode(line, this, r));
                continue;
            }
            this.nodes.add(this.getEntry(line, r.getLine(), r.getLineNum(), this.config.separator));
        }
        SkriptLogger.setNode(this.parent);
        return this;
    }

    private final Node getEntry(String line, String orig, int lineNum, String separator) {
        int x = line.indexOf(separator);
        if (x == -1) {
            InvalidNode n = new InvalidNode(this, line, lineNum);
            Skript.error("missing separator '" + separator + "'");
            SkriptLogger.setNode(this);
            return n;
        }
        String key = line.substring(0, x).trim();
        String value = line.substring(x + separator.length()).trim();
        return new EntryNode(key, value, orig, this, lineNum);
    }

    public void convertToEntries(int levels) {
        this.convertToEntries(levels, this.config.separator);
    }

    public void convertToEntries(int levels, String separator) {
        if (levels < -1) {
            throw new IllegalArgumentException("levels must be >= -1");
        }
        if (!this.config.simple) {
            throw new SkriptAPIException("config is not simple");
        }
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = this.nodes.get(i);
            if (levels != 0 && n instanceof SectionNode) {
                ((SectionNode)n).convertToEntries(levels == -1 ? -1 : levels - 1, separator);
            }
            if (n instanceof SimpleNode) {
                this.nodes.set(i, this.getEntry(n.getName(), n.getOrig(), n.lineNum, separator));
            }
            ++i;
        }
    }

    @Override
    void save(PrintWriter w) {
        if (this.parent != null) {
            if (!this.modified) {
                w.println(String.valueOf(this.getIndentation()) + this.orig.trim());
            } else {
                w.println(String.valueOf(this.getIndentation()) + this.name + ":" + this.getComment());
            }
        }
        for (Node node : this.nodes) {
            node.save(w);
        }
        this.modified = false;
    }

    public boolean validate(SectionValidator validator) {
        return validator.validate(this);
    }

    public String get(String name, String def) {
        Node n = this.get(name);
        if (n == null || !(n instanceof EntryNode)) {
            return def;
        }
        return ((EntryNode)n).getValue();
    }
}

