/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.Verbosity;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.util.Validate;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkriptCommand {
    private final Trigger trigger;
    private final String pattern;
    private final List<Argument<?>> arguments;
    final String name;
    final String description;
    final String usage;
    final Collection<String> aliases;
    final String permission;
    final String permissionMessage;
    public static final int PLAYERS = 1;
    public static final int CONSOLE = 2;
    public static final int BOTH = 3;
    final int executableBy;

    public SkriptCommand(String name, String pattern, List<Argument<?>> arguments, String description, String usage, Collection<String> aliases, String permission, String permissionMessage, int executableBy, List<TriggerItem> items) {
        Validate.notNull(name, arguments, description, usage, aliases, items);
        this.pattern = pattern;
        this.name = name;
        this.description = description;
        this.usage = usage;
        this.aliases = aliases;
        this.executableBy = executableBy;
        this.trigger = new Trigger("command /" + name, new SimpleEvent(), items);
        this.permission = permission;
        this.permissionMessage = permissionMessage == null ? "You don't have the required permission to use this command" : permissionMessage;
        this.arguments = arguments;
    }

    public boolean execute(CommandSender sender, String commandLabel, String rest) {
        if (sender instanceof Player) {
            if ((this.executableBy & 1) == 0) {
                sender.sendMessage("This command can only be used by the console");
                return false;
            }
        } else if ((this.executableBy & 2) == 0) {
            sender.sendMessage("This command can only be used by players");
            return false;
        }
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            sender.sendMessage(this.permissionMessage);
            return false;
        }
        SkriptCommandEvent event = new SkriptCommandEvent(this, sender);
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        boolean ok = SkriptParser.parseArguments(rest, this, event);
        SkriptLogger.stopSubLog(log);
        if (!ok) {
            log.printErrors(sender, null);
            sender.sendMessage("Correct usage: " + this.usage);
            return false;
        }
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# /" + this.name + " " + rest);
        }
        long startTrigger = System.nanoTime();
        this.trigger.run(event);
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# " + this.name + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
        }
        return true;
    }

    public void sendHelp(CommandSender sender) {
        if (!this.description.isEmpty()) {
            sender.sendMessage(this.description);
        }
        sender.sendMessage("Usage: " + this.usage);
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getDescription() {
        return this.description;
    }
}

