/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.SkriptCommand;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Commands {
    private static final SectionValidator commandStructure = new SectionValidator().addEntry("usage", true).addEntry("description", true).addEntry("permission", true).addEntry("permission message", true).addEntry("aliases", true).addEntry("executable by", true).addSection("trigger", false);
    public static List<Argument<?>> currentArguments = null;
    private static final String escape = Pattern.quote("(|)<>%\\");

    private static final String escape(String s) {
        return s.replaceAll("([" + escape + "])", "\\\\$1");
    }

    private static final String unescape(String s) {
        return s.replaceAll("\\\\([" + escape + "])", "$1");
    }

    public static final boolean loadCommand(SectionNode node) {
        String s = node.getName();
        int level = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '[') {
                ++level;
            } else if (s.charAt(i) == ']') {
                if (level == 0) {
                    Skript.error("Invalid placement of [optional brackets]");
                    return false;
                }
                --level;
            }
            ++i;
        }
        if (level > 0) {
            Skript.error("Invalid amount of [optional brackets]");
            return false;
        }
        Matcher m = Pattern.compile("(?i)^command /?(\\S+)(\\s+(.+))?$").matcher(s);
        boolean a = m.matches();
        assert (a);
        String command = m.group(1);
        if (Skript.commandExists(command)) {
            Skript.error("A command with the name /" + command + " is already defined");
            return false;
        }
        String arguments = m.group(3) == null ? "" : m.group(3);
        StringBuilder pattern = new StringBuilder();
        currentArguments = new ArrayList();
        m = Pattern.compile("<([a-zA-Z -]+?)\\s*(=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?>").matcher(arguments);
        int lastEnd = 0;
        int optionals = 0;
        int i2 = 0;
        while (m.find()) {
            pattern.append(Commands.escape(arguments.substring(lastEnd, m.start())));
            optionals += StringUtils.count(arguments, '[', lastEnd, m.start());
            optionals -= StringUtils.count(arguments, ']', lastEnd, m.start());
            lastEnd = m.end();
            ClassInfo<?> c = Skript.getClassInfoFromUserInput(m.group(1));
            Pair<String, Boolean> p = Utils.getPlural(m.group(1));
            if (c == null) {
                c = Skript.getClassInfoFromUserInput((String)p.first);
            }
            if (c == null) {
                Skript.error("unknown type '" + m.group(1) + "'");
                return false;
            }
            if (c.getParser() == null || !c.getParser().canParse(ParseContext.COMMAND)) {
                Skript.error("can't use " + m.group(1) + " as argument of a command");
                return false;
            }
            Argument<?> arg = Argument.newInstance(c.getC(), m.group(3), i2, (Boolean)p.second == false);
            if (arg == null) {
                return false;
            }
            currentArguments.add(arg);
            if (!arg.isOptional() && optionals > 0) {
                Skript.error("can't put an argument into [optional brackets] if no default value is given");
                return false;
            }
            if (arg.isOptional() && optionals == 0) {
                pattern.append('[');
            }
            pattern.append("%" + (arg.isOptional() ? "-" : "") + Utils.toPlural(c.getCodeName(), (Boolean)p.second) + "%");
            if (arg.isOptional() && optionals == 0) {
                pattern.append(']');
            }
            ++i2;
        }
        pattern.append(Commands.escape(arguments.substring(lastEnd)));
        optionals += StringUtils.count(arguments, '[', lastEnd);
        assert ((optionals -= StringUtils.count(arguments, ']', lastEnd)) == 0);
        node.convertToEntries(0);
        commandStructure.validate(node);
        if (!(node.get("trigger") instanceof SectionNode)) {
            return false;
        }
        String desc = "/" + command + " " + Commands.unescape(pattern.toString().replaceAll("%-?(.+?)%", "<$1>"));
        String usage = node.get("usage", desc);
        String description = node.get("description", "");
        List<String> aliases = Arrays.asList(node.get("aliases", "").split("\\s*,\\s*/?"));
        if (aliases.get(0).startsWith("/")) {
            aliases.set(0, aliases.get(0).substring(1));
        } else if (aliases.get(0).isEmpty()) {
            aliases = new ArrayList<String>(0);
        }
        String permission = node.get("permission", null);
        String permissionMessage = node.get("permission message", null);
        SectionNode trigger = (SectionNode)node.get("trigger");
        String[] by = node.get("executable by", "console,players").split("\\s*,\\s*|\\s+(and|or)\\s+");
        int executableBy = 0;
        String[] stringArray = by;
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            String b = stringArray[n2];
            if (b.equalsIgnoreCase("console") || b.equalsIgnoreCase("the console")) {
                executableBy |= 2;
            } else if (b.equalsIgnoreCase("players") || b.equalsIgnoreCase("player")) {
                executableBy |= 1;
            } else {
                Skript.error("'executable by' should be either be 'players', 'console' or both, but found '" + b + "'");
            }
            ++n2;
        }
        if (permissionMessage != null && permission == null) {
            Skript.warning("command /" + command + " has a permission message set, but not a permission");
        }
        if (Skript.debug()) {
            Skript.info("command " + desc + ":");
        }
        Skript.registerCommand(new SkriptCommand(command, pattern.toString().replaceAll("[<>]", "\\\\$0"), currentArguments, description, usage, aliases, permission, permissionMessage, executableBy, ScriptLoader.loadItems(trigger)));
        if (Skript.logVeryHigh() && !Skript.debug()) {
            Skript.info("registered command " + desc);
        }
        currentArguments = null;
        return true;
    }
}

