/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;

public class Argument<T> {
    private final Expression<? extends T> def;
    private final Class<T> type;
    private final boolean single;
    private final int index;
    private T[] current;

    public Argument(Expression<? extends T> def, Class<T> type, boolean single, int index) {
        this.def = def;
        this.type = type;
        this.single = single;
        this.index = index;
    }

    public static <T> Argument<T> newInstance(Class<T> type, String def, int index, boolean single) {
        Expression<T> d = null;
        if (def != null) {
            if (def.startsWith("%") && def.endsWith("%")) {
                Expression e = (Expression)SkriptParser.parse(def.substring(1, def.length() - 1), Skript.getExpressions().iterator(), false, true, "Can't understand the expression '" + def + "'");
                if (e == null) {
                    return null;
                }
                SkriptLogger.SubLog log = SkriptLogger.startSubLog();
                d = e.getConvertedExpression(type);
                SkriptLogger.stopSubLog(log);
                if (d == null) {
                    log.printErrors("'" + def + "' is not " + Utils.a(Skript.getExactClassName(type)));
                    return null;
                }
            } else {
                SkriptLogger.SubLog log = SkriptLogger.startSubLog();
                d = SkriptParser.parseLiteral(def, type, ParseContext.DEFAULT);
                SkriptLogger.stopSubLog(log);
                if (d == null) {
                    log.printErrors("'" + def + "' is not " + Utils.a(Skript.getExactClassName(type)));
                    return null;
                }
            }
        }
        return new Argument<T>(d, type, single, index);
    }

    public String toString() {
        return "<" + Skript.getExactClassName(this.type) + (this.single ? "" : "s") + (this.def == null ? "" : " = " + this.def.toString()) + ">";
    }

    public boolean isOptional() {
        return this.def != null;
    }

    public void setToDefault(SkriptCommandEvent event) {
        assert (this.def != null);
        this.current = this.def.getArray(event);
    }

    public void set(Object[] o) {
        if (o == null || !this.type.isAssignableFrom(o.getClass().getComponentType())) {
            throw new IllegalArgumentException();
        }
        this.current = o;
    }

    public T[] getCurrent() {
        return this.current;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSingle() {
        return this.single;
    }
}

