/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.util.BlockStateBlock;
import ch.njol.skript.util.DelayedChangeBlock;
import ch.njol.skript.util.Getter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.painting.PaintingEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.WeatherEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.inventory.ItemStack;

public final class BukkitEventValues {
    static {
        Skript.registerEventValue(WorldEvent.class, World.class, new Getter<World, WorldEvent>(){

            @Override
            public World get(WorldEvent e) {
                return e.getWorld();
            }
        }, 0);
        Skript.registerEventValue(WeatherEvent.class, World.class, new Getter<World, WeatherEvent>(){

            @Override
            public World get(WeatherEvent e) {
                return e.getWorld();
            }
        }, 0);
        Skript.registerEventValue(BlockEvent.class, Block.class, new Getter<Block, BlockEvent>(){

            @Override
            public Block get(BlockEvent e) {
                return e.getBlock();
            }
        }, 0);
        Skript.registerEventValue(BlockEvent.class, Location.class, new Getter<Location, BlockEvent>(){

            @Override
            public Location get(BlockEvent e) {
                return e.getBlock().getLocation().add(0.5, 0.5, 0.5);
            }
        }, 0);
        Skript.registerEventValue(BlockPlaceEvent.class, Player.class, new Getter<Player, BlockPlaceEvent>(){

            @Override
            public Player get(BlockPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(BlockPlaceEvent.class, Block.class, new Getter<Block, BlockPlaceEvent>(){

            @Override
            public Block get(BlockPlaceEvent e) {
                return new BlockStateBlock(e.getBlockReplacedState());
            }
        }, -1);
        Skript.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return e.getBlock();
            }
        }, -1);
        Skript.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new DelayedChangeBlock(e.getBlock(), e.getNewState());
            }
        }, 0);
        Skript.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new BlockStateBlock(e.getNewState());
            }
        }, 1);
        Skript.registerEventValue(BlockFormEvent.class, Block.class, new Getter<Block, BlockFormEvent>(){

            @Override
            public Block get(BlockFormEvent e) {
                if (e instanceof BlockSpreadEvent) {
                    return e.getBlock();
                }
                return new BlockStateBlock(e.getNewState());
            }
        }, 0);
        Skript.registerEventValue(BlockFormEvent.class, Block.class, new Getter<Block, BlockFormEvent>(){

            @Override
            public Block get(BlockFormEvent e) {
                return e.getBlock();
            }
        }, -1);
        Skript.registerEventValue(BlockDamageEvent.class, Player.class, new Getter<Player, BlockDamageEvent>(){

            @Override
            public Player get(BlockDamageEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(BlockBreakEvent.class, Player.class, new Getter<Player, BlockBreakEvent>(){

            @Override
            public Player get(BlockBreakEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                return e.getBlock();
            }
        }, -1);
        Skript.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                return new DelayedChangeBlock(e.getBlock());
            }
        }, 0);
        Skript.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                BlockState s;
                s.setType((s = e.getBlock().getState()).getType() == Material.ICE ? Material.STATIONARY_WATER : Material.AIR);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        Skript.registerEventValue(BlockIgniteEvent.class, Player.class, new Getter<Player, BlockIgniteEvent>(){

            @Override
            public Player get(BlockIgniteEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(BlockDispenseEvent.class, ItemStack.class, new Getter<ItemStack, BlockDispenseEvent>(){

            @Override
            public ItemStack get(BlockDispenseEvent e) {
                return e.getItem();
            }
        }, 0);
        Skript.registerEventValue(BlockPistonEvent.class, BlockFace.class, new Getter<BlockFace, BlockPistonEvent>(){

            @Override
            public BlockFace get(BlockPistonEvent e) {
                return e.getDirection();
            }
        }, 0);
        Skript.registerEventValue(SignChangeEvent.class, Player.class, new Getter<Player, SignChangeEvent>(){

            @Override
            public Player get(SignChangeEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(EntityEvent.class, Entity.class, new Getter<Entity, EntityEvent>(){

            @Override
            public Entity get(EntityEvent e) {
                return e.getEntity();
            }
        }, 0, "Use 'attacker' and/or 'victim' in damage events", EntityDamageEvent.class);
        Skript.registerEventValue(EntityDamageEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDamageEvent>(){

            @Override
            public EntityDamageEvent.DamageCause get(EntityDamageEvent e) {
                return e.getCause();
            }
        }, 0);
        Skript.registerEventValue(EntityDeathEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDeathEvent>(){

            @Override
            public EntityDamageEvent.DamageCause get(EntityDeathEvent e) {
                return e.getEntity().getLastDamageCause().getCause();
            }
        }, 0);
        Skript.registerEventValue(EntityDamageByEntityEvent.class, Projectile.class, new Getter<Projectile, EntityDamageByEntityEvent>(){

            @Override
            public Projectile get(EntityDamageByEntityEvent e) {
                if (e.getDamager() instanceof Projectile) {
                    return (Projectile)e.getDamager();
                }
                return null;
            }
        }, 0);
        Skript.registerEventValue(EntityDeathEvent.class, Projectile.class, new Getter<Projectile, EntityDeathEvent>(){

            @Override
            public Projectile get(EntityDeathEvent e) {
                if (e.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)e.getEntity().getLastDamageCause()).getDamager() instanceof Projectile) {
                    return (Projectile)((EntityDamageByEntityEvent)e.getEntity().getLastDamageCause()).getDamager();
                }
                return null;
            }
        }, 0);
        Skript.registerEventValue(EntityDeathEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDeathEvent>(){

            @Override
            public EntityDamageEvent.DamageCause get(EntityDeathEvent e) {
                return e.getEntity().getLastDamageCause().getCause();
            }
        }, 0);
        Skript.registerEventValue(ProjectileHitEvent.class, Entity.class, new Getter<Entity, ProjectileHitEvent>(){

            @Override
            public Entity get(ProjectileHitEvent e) {
                return e.getEntity().getShooter();
            }
        }, 0);
        Skript.registerEventValue(ProjectileHitEvent.class, Projectile.class, new Getter<Projectile, ProjectileHitEvent>(){

            @Override
            public Projectile get(ProjectileHitEvent e) {
                return e.getEntity();
            }
        }, 0);
        Skript.registerEventValue(PlayerEvent.class, Player.class, new Getter<Player, PlayerEvent>(){

            @Override
            public Player get(PlayerEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(PlayerQuitEvent.class, OfflinePlayer.class, new Getter<OfflinePlayer, PlayerQuitEvent>(){

            @Override
            public OfflinePlayer get(PlayerQuitEvent e) {
                return Bukkit.getOfflinePlayer((String)e.getPlayer().getName());
            }
        }, 0);
        Skript.registerEventValue(PlayerBedEnterEvent.class, Block.class, new Getter<Block, PlayerBedEnterEvent>(){

            @Override
            public Block get(PlayerBedEnterEvent e) {
                return e.getBed();
            }
        }, 0);
        Skript.registerEventValue(PlayerBedLeaveEvent.class, Block.class, new Getter<Block, PlayerBedLeaveEvent>(){

            @Override
            public Block get(PlayerBedLeaveEvent e) {
                return e.getBed();
            }
        }, 0);
        Skript.registerEventValue(PlayerBucketFillEvent.class, Block.class, new Getter<Block, PlayerBucketFillEvent>(){

            @Override
            public Block get(PlayerBucketFillEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, 0);
        Skript.registerEventValue(PlayerBucketFillEvent.class, Block.class, new Getter<Block, PlayerBucketFillEvent>(){

            @Override
            public Block get(PlayerBucketFillEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setTypeId(0);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        Skript.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new Getter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public Block get(PlayerBucketEmptyEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, -1);
        Skript.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new Getter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public Block get(PlayerBucketEmptyEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setType(e.getBucket() == Material.WATER_BUCKET ? Material.STATIONARY_WATER : Material.STATIONARY_LAVA);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 0);
        Skript.registerEventValue(PlayerDropItemEvent.class, Item.class, new Getter<Item, PlayerDropItemEvent>(){

            @Override
            public Item get(PlayerDropItemEvent e) {
                return e.getItemDrop();
            }
        }, 0);
        Skript.registerEventValue(PlayerInteractEntityEvent.class, Entity.class, new Getter<Entity, PlayerInteractEntityEvent>(){

            @Override
            public Entity get(PlayerInteractEntityEvent e) {
                return e.getRightClicked();
            }
        }, 0);
        Skript.registerEventValue(PlayerInteractEvent.class, Block.class, new Getter<Block, PlayerInteractEvent>(){

            @Override
            public Block get(PlayerInteractEvent e) {
                return e.getClickedBlock();
            }
        }, 0);
        Skript.registerEventValue(PlayerShearEntityEvent.class, Entity.class, new Getter<Entity, PlayerShearEntityEvent>(){

            @Override
            public Entity get(PlayerShearEntityEvent e) {
                return e.getEntity();
            }
        }, 0);
        Skript.registerEventValue(PaintingEvent.class, Painting.class, new Getter<Painting, PaintingEvent>(){

            @Override
            public Painting get(PaintingEvent e) {
                return e.getPainting();
            }
        }, 0);
        Skript.registerEventValue(PaintingPlaceEvent.class, Player.class, new Getter<Player, PaintingPlaceEvent>(){

            @Override
            public Player get(PaintingPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        Skript.registerEventValue(VehicleEvent.class, Vehicle.class, new Getter<Vehicle, VehicleEvent>(){

            @Override
            public Vehicle get(VehicleEvent e) {
                return e.getVehicle();
            }
        }, 0);
        Skript.registerEventValue(VehicleExitEvent.class, LivingEntity.class, new Getter<LivingEntity, VehicleExitEvent>(){

            @Override
            public LivingEntity get(VehicleExitEvent e) {
                return e.getExited();
            }
        }, 0);
        Skript.registerEventValue(VehicleEvent.class, Entity.class, new Getter<Entity, VehicleEvent>(){

            @Override
            public Entity get(VehicleEvent e) {
                return e.getVehicle().getPassenger();
            }
        }, 0);
        Skript.registerEventValue(CommandEvent.class, CommandSender.class, new Getter<CommandSender, CommandEvent>(){

            @Override
            public CommandSender get(CommandEvent e) {
                return e.getSender();
            }
        }, 0);
    }
}

