/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.EffDelay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Callback;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.event.Event;

public final class ScriptLoader {
    public static Config currentScript = null;
    public static SkriptEvent currentEvent = null;
    public static Class<? extends Event>[] currentEvents = null;
    public static List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    public static List<Loop> currentLoops = new ArrayList<Loop>();
    public static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    public static final HashMap<String, String> currentOptions = new HashMap();
    static int loadedTriggers = 0;
    static int loadedCommands = 0;
    private static String indentation = "";
    static final Collection<Trigger> selfRegisteredTriggers = new ArrayList<Trigger>();
    public static boolean hasDelayBefore = false;

    private ScriptLoader() {
    }

    private static final String replaceOptions(String s) {
        return StringUtils.replaceAll(s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                String option = currentOptions.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return null;
                }
                return option;
            }
        });
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        for (Node n : node) {
            Condition cond;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String ex = ScriptLoader.replaceOptions(e.getName());
                if (ex == null || (stmt = Statement.parse(ex, "can't understand this condition/effect: '" + ex + "'")) == null) continue;
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof EffDelay)) continue;
                hasDelayBefore = true;
                continue;
            }
            if (!(n instanceof SectionNode)) continue;
            if (n.getName().startsWith("loop ")) {
                Expression loopedExpr;
                String l = ScriptLoader.replaceOptions(n.getName().substring("loop ".length()));
                if (l == null || (loopedExpr = (Expression)SkriptParser.parse(l, Skript.getExpressions().iterator(), false, false, "can't understand this expression: '" + n.getName() + "'")) == null) continue;
                if (!loopedExpr.canLoop()) {
                    Skript.error("Can't loop " + loopedExpr);
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                Loop loop = new Loop(loopedExpr, (SectionNode)n);
                items.add(loop);
                continue;
            }
            if (n.getName().equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional)) {
                    Skript.error("'else' has to be placed just after the end of a conditional section");
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "else:");
                }
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                continue;
            }
            String name = n.getName();
            if (name.startsWith("if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(indentation) + cond.toString(null, true) + ":");
            }
            items.add(new Conditional(cond, (SectionNode)n));
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    static void load(Config config) {
        int numTriggers = 0;
        int numCommands = 0;
        currentAliases.clear();
        currentOptions.clear();
        currentScript = config;
        for (Node cnode : config.getMainNode()) {
            Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parsedEvent;
            if (!(cnode instanceof SectionNode)) {
                Skript.error("invalid line - all code has to be put into triggers");
                continue;
            }
            SectionNode node = (SectionNode)cnode;
            String event = node.getName();
            if (event.equalsIgnoreCase("aliases")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in alias section");
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)n).getValue());
                    if (t == null) continue;
                    currentAliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                }
                continue;
            }
            if (event.equalsIgnoreCase("options")) {
                node.convertToEntries(0);
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in options");
                        continue;
                    }
                    currentOptions.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                }
                continue;
            }
            if (event.equalsIgnoreCase("variables")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    String var;
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in variables");
                        continue;
                    }
                    String name = ((EntryNode)n).getKey();
                    if (name.startsWith("{") && name.endsWith("}")) {
                        name = name.substring(1, name.length() - 1);
                    }
                    if ((name = StringUtils.replaceAll(name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                        private final /* synthetic */ String val$var;
                        {
                            this.val$var = string;
                        }

                        @Override
                        public String run(Matcher m) {
                            if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                return null;
                            }
                            ClassInfo<?> ci = Skript.getClassInfoFromUserInput(m.group(1));
                            if (ci == null) {
                                Skript.error("Can't understand the type '" + m.group(1) + "'");
                                return null;
                            }
                            return "<" + ci.getCodeName() + ">";
                        }
                    })) == null || name.contains("%") || Skript.getVariable(name) != null) continue;
                    SkriptLogger.SubLog log = SkriptLogger.startSubLog();
                    Object o = Skript.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.CONFIG);
                    SkriptLogger.stopSubLog(log);
                    if (o == null) {
                        log.printErrors("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                        continue;
                    }
                    ClassInfo<?> ci = Skript.getSuperClassInfo(o.getClass());
                    if (ci.getSerializeAs() != null) {
                        ClassInfo<?> as = Skript.getSuperClassInfo(ci.getSerializeAs());
                        if (as == null) {
                            Skript.exception("Missing class info for " + ci.getSerializeAs().getName() + ", the class to serialize " + ci.getC().getName() + " as");
                            continue;
                        }
                        if ((o = Skript.convert(o, as.getC())) == null) {
                            Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                            continue;
                        }
                    }
                    Skript.setVariable(name, o);
                }
                continue;
            }
            if (StringUtils.count(event, '\"') % 2 != 0) {
                Skript.error("Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".");
                continue;
            }
            hasDelayBefore = false;
            if (event.toLowerCase().startsWith("command ")) {
                currentEvent = null;
                currentEvents = Skript.array(CommandEvent.class);
                if (!Commands.loadCommand(node)) continue;
                ++numCommands;
                continue;
            }
            if (Skript.logVeryHigh() && !Skript.debug()) {
                Skript.info("loading trigger '" + event + "'");
            }
            if (event.toLowerCase().startsWith("on ")) {
                event = event.substring("on ".length());
            }
            if ((event = ScriptLoader.replaceOptions(event)) == null || (parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(event) + " (" + ((SkriptEvent)parsedEvent.second).toString(null, true) + "):");
            }
            currentEvent = (SkriptEvent)parsedEvent.second;
            currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
            Trigger trigger = new Trigger(event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
            currentEvent = null;
            currentEvents = null;
            if (((SkriptEvent.SkriptEventInfo)parsedEvent.first).fire) {
                SkriptEventHandler.addTrigger(((SkriptEvent.SkriptEventInfo)parsedEvent.first).events, trigger);
            } else {
                ((SkriptEvent)parsedEvent.second).register(trigger);
                selfRegisteredTriggers.add(trigger);
            }
            ++numTriggers;
        }
        if (Skript.logHigh()) {
            Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
        }
        loadedCommands += numCommands;
        loadedTriggers += numTriggers;
        currentScript = null;
    }

    static Trigger loadTrigger(SectionNode node) {
        String event = node.getName();
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'");
        currentEvent = (SkriptEvent)parsedEvent.second;
        currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
        Trigger t = new Trigger(event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
        currentEvent = null;
        currentEvents = null;
        return t;
    }
}

