/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;

public enum WeatherType {
    CLEAR("clear", "sun", "sunny"),
    RAIN("rain", "rainy", "raining"),
    THUNDER("thunder", "thundering");

    private final String[] names;
    private static final Map<String, WeatherType> byName;

    static {
        byName = new HashMap<String, WeatherType>();
        WeatherType[] weatherTypeArray = WeatherType.values();
        int n = weatherTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WeatherType t = weatherTypeArray[n2];
            String[] stringArray = t.names;
            int n3 = t.names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                byName.put(name, t);
                ++n4;
            }
            ++n2;
        }
    }

    private WeatherType(String ... names) {
        this.names = names;
    }

    public static final WeatherType parse(String s) {
        return byName.get(s);
    }

    public static WeatherType fromWorld(World world) {
        if (world == null) {
            return null;
        }
        if (world.isThundering()) {
            return THUNDER;
        }
        if (world.hasStorm()) {
            return RAIN;
        }
        return CLEAR;
    }

    public String toString() {
        return this.names[0];
    }

    public String adjective() {
        switch (this) {
            case CLEAR: {
                return "sunny";
            }
            case RAIN: {
                return "raining";
            }
            case THUNDER: {
                return "thundering";
            }
        }
        throw new IllegalStateException();
    }

    public boolean isWeather(World w) {
        return this.isWeather(w.hasStorm(), w.isThundering());
    }

    public boolean isWeather(boolean rain, boolean thunder) {
        switch (this) {
            case CLEAR: {
                return !thunder && !rain;
            }
            case RAIN: {
                return !thunder && rain;
            }
            case THUNDER: {
                return thunder && rain;
            }
        }
        throw new RuntimeException();
    }

    public void setWeather(World w) {
        w.setStorm(this == RAIN || this == THUNDER);
        w.setThundering(this == THUNDER);
    }
}

