/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Debuggable;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Event;

public class VariableString
implements Debuggable {
    private final ArrayList<Object> string;
    private Event last = null;
    private String lastString = null;
    private final boolean isSimple;

    private VariableString(String s) {
        this.string = null;
        this.isSimple = true;
        this.lastString = s;
    }

    private VariableString(ArrayList<Object> string) {
        this.isSimple = false;
        this.string = string;
    }

    public static VariableString newInstance(String s) {
        ArrayList<Object> string = new ArrayList<Object>();
        int c = s.indexOf(37);
        if (c == -1) {
            return new VariableString(s);
        }
        string.add(s.substring(0, c));
        while (c != s.length()) {
            int b;
            int c2 = s.indexOf(37, c + 1);
            int a = c;
            while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                int b2 = s.indexOf(125, b + 1);
                if (b2 == -1) {
                    Skript.error("Missing closing bracket '}' to end variable");
                    return null;
                }
                c2 = s.indexOf(37, b2 + 1);
                a = b2;
            }
            if (c2 == -1) {
                Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a %, type it twice: %%.");
                return null;
            }
            if (c + 1 == c2) {
                string.add("%");
            } else {
                Expression expr = (Expression)SkriptParser.parse(s.substring(c + 1, c2), Skript.getExpressions().iterator(), false, true, "can't understand the expression %" + s.substring(c + 1, c2) + "%");
                if (expr == null) {
                    return null;
                }
                string.add(expr);
            }
            c = s.indexOf(37, c2 + 1);
            if (c == -1) {
                c = s.length();
            }
            string.add(s.substring(c2 + 1, c));
        }
        return new VariableString(string);
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        int i = 0;
        while (i < args.length) {
            VariableString vs = VariableString.newInstance(args[i]);
            if (vs != null) {
                strings[j++] = vs;
            }
            ++i;
        }
        if (j != args.length) {
            return Arrays.copyOf(strings, j);
        }
        return strings;
    }

    public static VariableString[] makeStringsFromQuoted(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int i = 0;
        while (i < args.length) {
            VariableString vs;
            if (!(!Skript.debug() || args[i].startsWith("\"") && args[i].endsWith("\""))) {
                Skript.warning("Call to VariableString.makeStringsFromQuoted with unquoted string: " + args[i]);
            }
            if ((vs = VariableString.newInstance(args[i].substring(1, args[i].length() - 1))) == null) {
                return null;
            }
            strings[i] = vs;
            ++i;
        }
        return strings;
    }

    public String get(Event e) {
        if (this.isSimple || this.last == e) {
            return this.lastString;
        }
        StringBuilder b = new StringBuilder();
        for (Object o : this.string) {
            if (o instanceof Expression) {
                if (((Expression)o).isSingle()) {
                    b.append(Skript.toString(((Expression)o).getSingle(e)));
                    continue;
                }
                b.append(Skript.toString(((Expression)o).getArray(e), ((Expression)o).getAnd()));
                continue;
            }
            b.append(o);
        }
        this.last = e;
        this.lastString = b.toString();
        return this.lastString;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (this.isSimple) {
            return String.valueOf('\"') + this.lastString + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        for (Object o : this.string) {
            if (o instanceof Expression) {
                b.append("%" + ((Expression)o).getDebugMessage(e) + "%");
                continue;
            }
            b.append(o);
        }
        b.append('\"');
        return b.toString();
    }

    public String toString() {
        if (this.isSimple) {
            return String.valueOf('\"') + this.lastString + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        for (Object o : this.string) {
            if (o instanceof Expression) {
                b.append("%" + o + "%");
                continue;
            }
            b.append(o);
        }
        b.append('\"');
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }
}

