/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Parser;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import java.util.HashMap;

public class Timespan {
    private final int ticks;

    static {
        final HashMap<String, Integer> simpleValues = new HashMap<String, Integer>();
        simpleValues.put("tick", 1);
        simpleValues.put("second", 20);
        simpleValues.put("minute", 1200);
        simpleValues.put("hour", 72000);
        simpleValues.put("day", 1728000);
        Skript.registerClass(new ClassInfo<Timespan>(Timespan.class, "timespan").parser(new Parser<Timespan>(){

            @Override
            public Timespan parse(String s) {
                if (s.isEmpty()) {
                    return null;
                }
                s = s.toLowerCase();
                int t = 0;
                boolean minecraftTime = false;
                boolean setMinecraftTime = false;
                if (s.matches("^\\d+:\\d\\d$")) {
                    String[] ss = s.split(":");
                    int[] times = new int[]{1200, 20};
                    int i = 0;
                    while (i < ss.length) {
                        t += times[i] * Integer.parseInt(ss[i]);
                        ++i;
                    }
                } else {
                    String[] subs = s.split("\\s+");
                    int i = 0;
                    while (i < subs.length) {
                        String sub = subs[i];
                        if (sub.equals("and")) {
                            if (i == 0 || i == subs.length - 1) {
                                return null;
                            }
                        } else {
                            float amount = 1.0f;
                            if (sub.matches("^\\d+(.\\d+)?$")) {
                                if (i == subs.length) {
                                    return null;
                                }
                                amount = Float.parseFloat(sub);
                                sub = subs[++i];
                            }
                            if (sub.equals("real") || sub.equals("rl") || sub.equals("irl")) {
                                if (i == subs.length || setMinecraftTime && minecraftTime) {
                                    return null;
                                }
                                sub = subs[++i];
                            } else if (sub.equals("mc") || sub.equals("minecraft")) {
                                if (i == subs.length || setMinecraftTime && !minecraftTime) {
                                    return null;
                                }
                                minecraftTime = true;
                                sub = subs[++i];
                            }
                            if (minecraftTime) {
                                amount /= 72.0f;
                            }
                            if (sub.endsWith(",")) {
                                sub = sub.substring(0, sub.length() - 1);
                            }
                            Pair<String, Boolean> p = Utils.getPlural(sub, amount != 1.0f);
                            sub = (String)p.first;
                            if (!simpleValues.containsKey(sub)) {
                                return null;
                            }
                            t += Math.round(amount * (float)((Integer)simpleValues.get(sub)).intValue());
                            setMinecraftTime = true;
                        }
                        ++i;
                    }
                }
                return new Timespan(t);
            }

            @Override
            public String toString(Timespan t) {
                return String.valueOf(Math.floor(t.ticks / 1000)) + ":" + Math.floor(t.ticks % 1000 * 60 / 1000);
            }
        }).serializer(new Serializer<Timespan>(){

            @Override
            public String serialize(Timespan t) {
                return "" + t.ticks;
            }

            @Override
            public Timespan deserialize(String s) {
                try {
                    return new Timespan(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
    }

    public Timespan(int ticks) {
        this.ticks = ticks;
    }

    public int getTicks() {
        return this.ticks;
    }
}

