/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopExpr;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class LoopVarPlayer
extends LoopExpr<Player> {
    private Expression<World> worlds = null;

    static {
        Skript.registerLoop(LoopVarPlayer.class, Player.class, "players", "players in world[s] %worlds%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        if (vars.length > 0) {
            this.worlds = vars[0];
        }
        return true;
    }

    @Override
    protected Iterator<Player> iterator(Event e) {
        if (this.worlds == null) {
            return Arrays.asList(Bukkit.getOnlinePlayers()).iterator();
        }
        return new Iterator<Player>(e){
            private final ListIterator<Player> players = Arrays.asList(Bukkit.getOnlinePlayers()).listIterator();
            private final World[] ws;
            {
                this.ws = (World[])LoopVarPlayer.this.worlds.getArray(event);
            }

            @Override
            public boolean hasNext() {
                while (this.players.hasNext()) {
                    if (Utils.indexOf(this.ws, this.players.next().getWorld()) == -1) continue;
                    this.players.previous();
                    return true;
                }
                return false;
            }

            @Override
            public Player next() {
                return this.players.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        return "players in world " + this.worlds.getDebugMessage(e);
    }

    @Override
    public String toString() {
        return "the loop-player";
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("player");
    }
}

