/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopExpr;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.BlockLineIterator;
import ch.njol.skript.util.Offset;
import java.util.Iterator;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class LoopVarBlockLine
extends LoopExpr<Block> {
    private static final int MAXDIST = 1000;
    private Expression<Block> start;
    private Expression<Block> end = null;
    private Expression<Offset> direction = null;

    static {
        Skript.registerLoop(LoopVarBlockLine.class, Block.class, "blocks from %block% to %block%", "blocks between %block% and %block%", "blocks from %block% on %offset%", "blocks %offset% %block%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: 
            case 1: {
                this.start = vars[0];
                this.end = vars[1];
                break;
            }
            case 2: {
                this.start = vars[0];
                this.direction = vars[1];
                break;
            }
            case 3: {
                this.direction = vars[0];
                this.start = vars[1];
            }
        }
        return true;
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        if (this.end != null) {
            return "blocks from " + this.start.getDebugMessage(e) + " to " + this.end.getDebugMessage(e);
        }
        return "blocks " + this.direction.getDebugMessage(e) + " " + this.start.getDebugMessage(e);
    }

    @Override
    protected Iterator<? extends Block> iterator(Event e) {
        Block b = this.start.getSingle(e);
        if (b == null) {
            return null;
        }
        if (this.direction != null) {
            Offset o = this.direction.getSingle(e);
            if (o == null) {
                return null;
            }
            return new BlockLineIterator(b, o.toVector(), 1000.0);
        }
        Block b2 = this.end.getSingle(e);
        if (b2 == null || b2.getWorld() != b.getWorld()) {
            return null;
        }
        return new BlockLineIterator(b, b2);
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("block");
    }

    @Override
    public String toString() {
        return "the loop-block";
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }
}

