/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Converter;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class Variable<T>
implements Expression<T> {
    private final VariableString name;
    private final Class<T> type;
    private final T[] zero;
    private final T[] one;

    public Variable(VariableString name, Class<T> type) {
        Validate.notNull(name, type);
        this.name = name;
        this.type = type;
        this.zero = (Object[])Array.newInstance(type, 0);
        this.one = (Object[])Array.newInstance(type, 1);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.type;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "{" + StringUtils.substring(this.name.getDebugMessage(e), 1, -1) + "}->" + this.type.getName();
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        return new Variable<R>(this.name, to);
    }

    protected T get(Event e) {
        return (T)(this.type == Object.class ? Skript.variables.get(this.name.get(e)) : Skript.convert(Skript.variables.get(this.name.get(e)), this.type));
    }

    @Override
    public String toString() {
        return "{" + StringUtils.substring(this.name.toString(), 1, -1) + "}";
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.CLEAR) {
            return this.type;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (mode == Changer.ChangeMode.CLEAR) {
            Skript.variables.remove(this.name.get(e));
        } else if (mode == Changer.ChangeMode.SET) {
            ClassInfo<?> ci = Skript.getSuperClassInfo(delta.getClass());
            if (ci != null && ci.getSerializeAs() != null) {
                Skript.variables.put(this.name.get(e), Skript.convert(delta, ci.getSerializeAs()));
            } else {
                Skript.variables.put(this.name.get(e), delta);
            }
        }
    }

    @Override
    public T getSingle(Event e) {
        return this.get(e);
    }

    @Override
    public T[] getArray(Event e) {
        this.one[0] = this.get(e);
        if (this.one[0] == null) {
            return this.zero;
        }
        return this.one;
    }

    @Override
    public <V> V getSingle(Event e, Converter<? super T, ? extends V> converter) {
        T t = this.get(e);
        if (t == null) {
            return null;
        }
        return converter.convert(t);
    }

    @Override
    public <V> V[] getArray(Event e, Class<V> to, Converter<? super T, ? extends V> converter) {
        return SimpleExpression.getArray(this, e, to, converter);
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, Condition cond) {
        return SimpleExpression.check(this.getArray(e), c, cond.isNegated(), this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.getArray(e), c, false, this.getAnd());
    }

    @Override
    public void setAnd(boolean and) {
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }
}

