/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.intern.ConvertedLiteral;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkriptParser {
    private final String expr;
    final boolean parseStatic;
    private String bestError = null;
    private int bestErrorQuality = 0;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";

    private SkriptParser(String expr) {
        this.expr = expr;
        this.parseStatic = false;
    }

    private SkriptParser(String expr, boolean parseStatic) {
        this.expr = expr;
        this.parseStatic = parseStatic;
    }

    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c) {
        return SkriptParser.makeUnparsedLiteral(expr).getConvertedExpr(c);
    }

    public static final SyntaxElement parse(String expr, Iterator<? extends SyntaxElementInfo<?>> source, boolean parseLiteral, boolean parseVariable, String defaultError) {
        Variable<Object> var = SkriptParser.parseVariable(expr, Object.class);
        if (var != null) {
            if (parseVariable) {
                return var;
            }
            return null;
        }
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        SyntaxElement e = SkriptParser.parse(expr, source, null);
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        if (parseLiteral) {
            return SkriptParser.makeUnparsedLiteral(expr);
        }
        log.printErrors(defaultError);
        return null;
    }

    public static final SyntaxElement parse(String expr, Iterator<? extends SyntaxElementInfo<?>> source, String defaultError) {
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        SyntaxElement e = new SkriptParser(expr).parse(source);
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final SyntaxElement parse(Iterator<? extends SyntaxElementInfo<?>> source) {
        while (source.hasNext()) {
            info = source.next();
            i = 0;
            while (i < info.patterns.length) {
                block15: {
                    res = this.parse_i(info.patterns[i], 0, 0);
                    if (res == null) ** GOTO lbl43
                    x = -1;
                    j = 0;
                    while ((x = SkriptParser.next(info.patterns[i], '%', x + 1)) != -1) {
                        x2 = SkriptParser.next(info.patterns[i], '%', x + 1);
                        if (res.vars[j] == null && !(name = info.patterns[i].substring(x + 1, x2)).startsWith("-")) {
                            vi = SkriptParser.getVarInfo(name);
                            var = Skript.getDefaultExpression(vi.name);
                            if (var == null) {
                                throw new SkriptAPIException("The class '" + vi.name + "' does not provide a default expression. Either allow null (with %-" + vi.name + "%) or make it mandatory");
                            }
                            if (!vi.isPlural && !var.isSingle()) {
                                throw new SkriptAPIException("The default expression of '" + vi.name + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory");
                            }
                            if (vi.time != 0 && !var.setTime(vi.time)) {
                                throw new SkriptAPIException("The default expression of '" + vi.name + "' does not have distinct time states. Either allow null (with %-" + vi.name + "%) or make it mandatory");
                            }
                            var.init();
                            res.vars[j] = var;
                        }
                        x = x2;
                        ++j;
                    }
                    e = (SyntaxElement)info.c.newInstance();
                    log = SkriptLogger.startSubLog();
                    if (e.init(res.vars, i, res)) break block15;
                    SkriptLogger.stopSubLog(log);
                    if (log.hasErrors()) {
                        if (this.bestErrorQuality < ErrorQuality.SEMANTIC_ERROR.quality()) {
                            this.bestError = log.getLastError();
                            this.bestErrorQuality = ErrorQuality.SEMANTIC_ERROR.quality();
                        }
                        Skript.error(this.bestError);
                        return null;
                    }
                }
                try {
                    SkriptLogger.stopSubLog(log);
                    log.printLog();
                    return e;
lbl43:
                    // 1 sources

                    if (this.bestErrorQuality == ErrorQuality.SEMANTIC_ERROR.quality()) {
                        Skript.error(this.bestError);
                        return null;
                    }
                }
                catch (InstantiationException e) {
                    SkriptAPIException.instantiationException("the " + Skript.getSyntaxElementName(info.c), info.c, e);
                }
                catch (IllegalAccessException e) {
                    SkriptAPIException.inaccessibleConstructor(info.c, e);
                }
                ++i;
            }
        }
        if (this.bestError != null) {
            Skript.error(this.bestError);
        }
        return null;
    }

    private static final <T> Variable<T> parseVariable(String expr, Class<T> returnType) {
        if ((expr.startsWith("{") || expr.startsWith("variable {") || expr.startsWith("the variable {")) && expr.endsWith("}")) {
            VariableString vs = VariableString.newInstance(expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)));
            if (vs == null) {
                return null;
            }
            return new Variable<T>(vs, returnType);
        }
        return null;
    }

    private final <T> Expression<? extends T> parseExpr(Class<T> returnType, String expr, boolean literalOnly) {
        SkriptLogger.SubLog log;
        if (!literalOnly) {
            Variable<T> var = SkriptParser.parseVariable(expr, returnType);
            if (var != null) {
                return var;
            }
            log = SkriptLogger.startSubLog();
            SkriptParser parser = new SkriptParser(expr);
            Expression v = (Expression)parser.parse(Skript.getExpressions().iterator());
            SkriptLogger.stopSubLog(log);
            if (v != null) {
                Expression<T> w = v.getConvertedExpression(returnType);
                if (w == null && this.bestErrorQuality < ErrorQuality.EXPRESSION_OF_WRONG_TYPE.quality()) {
                    this.bestError = String.valueOf(v.toString()) + " " + (v.isSingle() ? "is" : "are") + " not " + Utils.a(Skript.getExactClassName(returnType));
                    this.bestErrorQuality = ErrorQuality.EXPRESSION_OF_WRONG_TYPE.quality();
                }
                return w;
            }
            if (parser.bestErrorQuality > this.bestErrorQuality) {
                this.bestError = parser.bestError;
                this.bestErrorQuality = parser.bestErrorQuality;
            }
        }
        UnparsedLiteral l = SkriptParser.makeUnparsedLiteral(expr);
        if (returnType == Object.class) {
            return l;
        }
        log = SkriptLogger.startSubLog();
        ConvertedLiteral<Object, T> p = l.getConvertedExpr(returnType);
        SkriptLogger.stopSubLog(log);
        if (p == null && this.bestErrorQuality < ErrorQuality.NOT_AN_EXPRESSION.quality()) {
            this.bestError = log.getLastError() == null ? "'" + expr + "' is not " + Utils.a(Skript.getExactClassName(returnType)) : log.getLastError();
            this.bestErrorQuality = ErrorQuality.NOT_AN_EXPRESSION.quality();
        }
        return p;
    }

    public static Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(event, true).parseEvent();
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    private Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        for (SkriptEvent.SkriptEventInfo<?> info : Skript.getEvents()) {
            int i = 0;
            while (i < info.patterns.length) {
                try {
                    ParseResult res = this.parse_i(info.patterns[i], 0, 0);
                    if (res != null) {
                        SkriptEvent e = (SkriptEvent)info.c.newInstance();
                        e.init((Literal[])Arrays.copyOf(res.vars, res.vars.length, Literal[].class), i, res);
                        return new Pair(info, e);
                    }
                    if (this.bestErrorQuality == ErrorQuality.SEMANTIC_ERROR.quality()) {
                        Skript.error(this.bestError);
                        return null;
                    }
                }
                catch (InstantiationException e) {
                    SkriptAPIException.instantiationException("the event", info.c, e);
                }
                catch (IllegalAccessException e) {
                    SkriptAPIException.inaccessibleConstructor(info.c, e);
                }
                ++i;
            }
        }
        if (this.bestError != null) {
            Skript.error(this.bestError);
        }
        return null;
    }

    private static int nextBracket(String s, char closingBracket, char openingBracket, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        throw new MalformedPatternException(s, "missing closing bracket '" + closingBracket + "'");
    }

    private static int next(String s, char c, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean hasOnly(String s, String chars, int start, int end) {
        int i = start;
        while (i < end) {
            if (chars.indexOf(s.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final ParseResult parse_i(String pattern, int i, int j) {
        if (this.expr.isEmpty()) {
            throw new SkriptAPIException("Empty expression (pattern: " + pattern + ")");
        }
        int matchedChars = 0;
        while (j < pattern.length()) {
            switch (pattern.charAt(j)) {
                case '[': {
                    ParseResult res = this.parse_i(pattern, i, j + 1);
                    if (res != null) {
                        return res;
                    }
                    int end = SkriptParser.nextBracket(pattern, ']', '[', j + 1);
                    if ((SkriptParser.hasOnly(pattern, "[(", 0, j) || pattern.charAt(j - 1) == ' ') && end < pattern.length() - 1 && pattern.charAt(end + 1) == ' ') {
                        ++end;
                    }
                    j = end + 1;
                    break;
                }
                case '(': {
                    ParseResult res;
                    int end = SkriptParser.nextBracket(pattern, ')', '(', j + 1);
                    String[] gs = pattern.substring(j + 1, end).split("\\|");
                    int j2 = j + 1;
                    int k = 0;
                    while (k < gs.length) {
                        res = this.parse_i(pattern, i, j2);
                        if (res != null) {
                            return res;
                        }
                        j2 += gs[k].length() + 1;
                        ++k;
                    }
                    return null;
                }
                case '%': {
                    int i2;
                    ParseResult res;
                    if (i == this.expr.length()) {
                        return null;
                    }
                    int end = SkriptParser.next(pattern, '%', j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "odd number of '%'");
                    }
                    String name = pattern.substring(j + 1, end);
                    if (name.startsWith("-")) {
                        name = name.substring(1);
                    }
                    VarInfo vi = SkriptParser.getVarInfo(name);
                    name = vi.name;
                    Class<?> returnType = Skript.getClass(name);
                    if (end == pattern.length() - 1) {
                        i2 = this.expr.length();
                    } else if (this.expr.charAt(i) == '\"') {
                        i2 = SkriptParser.nextQuote(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else if (this.expr.charAt(i) == '{') {
                        i2 = this.expr.indexOf(125, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else {
                        i2 = i + 1;
                    }
                    while (i2 <= this.expr.length()) {
                        if (i2 < this.expr.length() && (this.expr.charAt(i2) == '\"' ? (i2 = SkriptParser.nextQuote(this.expr, i2 + 1) + 1) == 0 : this.expr.charAt(i2) == '{' && (i2 = this.expr.indexOf(125, i2 + 1) + 1) == 0)) {
                            return null;
                        }
                        res = this.parse_i(pattern, i2, end + 1);
                        if (res != null) {
                            Expression<?> var = this.parseExpr(returnType, this.expr.substring(i, i2), this.parseStatic);
                            if (var != null) {
                                if (!vi.isPlural && !var.isSingle()) {
                                    if (this.bestErrorQuality < ErrorQuality.SEMANTIC_ERROR.quality()) {
                                        this.bestError = "this expression can only accept a single " + Skript.getExactClassName(returnType) + ", but multiple are given.";
                                        this.bestErrorQuality = ErrorQuality.SEMANTIC_ERROR.quality();
                                    }
                                    return null;
                                }
                                if (vi.time != 0 && !var.setTime(vi.time)) {
                                    if (this.bestErrorQuality < ErrorQuality.SEMANTIC_ERROR.quality()) {
                                        this.bestError = var + " does not have a " + (vi.time == -1 ? "past" : "future") + " state";
                                        this.bestErrorQuality = ErrorQuality.SEMANTIC_ERROR.quality();
                                    }
                                    return null;
                                }
                                res.vars[StringUtils.count((String)pattern, (char)'%', (int)0, (int)(j - 1)) / 2] = var;
                                return res;
                            }
                            if (this.bestErrorQuality < ErrorQuality.NOT_AN_EXPRESSION.quality() && res.matchedChars + matchedChars >= 5) {
                                this.bestError = "'" + this.expr.substring(i, i2) + "' is not " + Utils.a(Skript.getExactClassName(returnType));
                                this.bestErrorQuality = ErrorQuality.NOT_AN_EXPRESSION.quality();
                            }
                        }
                        ++i2;
                    }
                    return null;
                }
                case '<': {
                    ParseResult res;
                    int end = pattern.indexOf(62, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "missing closing regex bracket '>'");
                    }
                    int i2 = i + 1;
                    while (i2 <= this.expr.length()) {
                        Matcher m;
                        res = this.parse_i(pattern, i2, end + 1);
                        if (res != null && (m = Pattern.compile(pattern.substring(j + 1, end)).matcher(this.expr.substring(i, i2))).matches()) {
                            res.regexes.add(0, m.toMatchResult());
                            return res;
                        }
                        ++i2;
                    }
                    return null;
                }
                case ')': 
                case ']': {
                    ++j;
                    break;
                }
                case '|': {
                    j = SkriptParser.nextBracket(pattern, ')', '(', j + 1) + 1;
                    break;
                }
                case ' ': {
                    if (i == this.expr.length() || i > 0 && this.expr.charAt(i - 1) == ' ') {
                        ++j;
                        break;
                    }
                    if (this.expr.charAt(i) != ' ') {
                        return null;
                    }
                    ++matchedChars;
                    ++i;
                    ++j;
                    break;
                }
                case '\\': {
                    if (++j == pattern.length()) {
                        throw new MalformedPatternException(pattern, "must not end with a backslash");
                    }
                }
                default: {
                    if (i == this.expr.length() || Character.toLowerCase(pattern.charAt(j)) != Character.toLowerCase(this.expr.charAt(i))) {
                        return null;
                    }
                    ++matchedChars;
                    ++i;
                    ++j;
                }
            }
        }
        if (i == this.expr.length() && j == pattern.length()) {
            return new ParseResult(this.expr, pattern, matchedChars);
        }
        return null;
    }

    private static final UnparsedLiteral makeUnparsedLiteral(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        Pattern p = Pattern.compile("^([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?)(,\\s*|,?\\s+and\\s+|,?\\s+n?or\\s+)");
        Matcher m = p.matcher(s);
        int prevEnd = 0;
        boolean and = true;
        boolean isAndSet = false;
        while (m.find()) {
            if (!m.group(2).matches(",\\s*")) {
                if (isAndSet) {
                    Skript.warning("list has multiple 'and' or 'or', will default to 'and': " + s);
                    and = true;
                } else {
                    and = m.group(2).contains("and");
                    isAndSet = true;
                }
            }
            parts.add(m.group(1).trim());
            prevEnd = m.end();
            m.region(m.end(), s.length());
        }
        if (!isAndSet && !parts.isEmpty()) {
            Skript.warning("list is missing 'and' or 'or', will default to 'and': " + s);
        }
        parts.add(s.substring(prevEnd).trim());
        return new UnparsedLiteral(parts.toArray(new String[0]), and);
    }

    private static VarInfo getVarInfo(String s) {
        String[] a = s.split("@", 2);
        VarInfo r = new VarInfo();
        if (a.length == 1) {
            r.name = s;
        } else {
            r.time = Integer.parseInt(a[1]);
            r.name = a[0];
        }
        Pair<String, Boolean> p = Utils.getPlural(r.name);
        r.name = (String)p.first;
        r.isPlural = (Boolean)p.second;
        return r;
    }

    private static enum ErrorQuality {
        NONE,
        NOT_AN_EXPRESSION,
        EXPRESSION_OF_WRONG_TYPE,
        SEMANTIC_ERROR;


        int quality() {
            return this.ordinal();
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -2479399963189481643L;

        public MalformedPatternException(String pattern, String message) {
            super("\"" + pattern + "\": " + message);
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] vars;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>();
        public final String expr;
        int matchedChars = 0;

        public ParseResult(String expr, String pattern, int matchedChars) {
            this.expr = expr;
            this.vars = new Expression[StringUtils.count(pattern, '%') / 2];
            this.matchedChars = matchedChars;
        }
    }

    private static final class VarInfo {
        String name;
        boolean isPlural;
        int time = 0;

        private VarInfo() {
        }
    }
}

