/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.DefaultExpression;
import ch.njol.skript.api.intern.ConvertedLiteral;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class SimpleLiteral<T>
extends SimpleExpression<T>
implements Literal<T>,
DefaultExpression<T> {
    protected final T[] data;
    protected final Class<T> c;
    private final boolean isDefault;

    public SimpleLiteral(T[] data, Class<T> c, boolean and) {
        this.data = data;
        this.c = c;
        this.setAnd(and);
        this.isDefault = false;
    }

    public SimpleLiteral(T data, boolean isDefault) {
        this.data = (Object[])Array.newInstance(data.getClass(), 1);
        this.data[0] = data;
        this.c = data.getClass();
        this.setAnd(true);
        this.isDefault = isDefault;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    protected T[] getAll(Event e) {
        return this.data;
    }

    @Override
    public T[] getArray() {
        return this.getArray(null);
    }

    @Override
    public T getSingle() {
        return this.getSingle(null);
    }

    @Override
    public Class<T> getReturnType() {
        return this.c;
    }

    @Override
    public <R> ConvertedLiteral<T, ? extends R> getConvertedExpr(Class<R> to) {
        if (to.isAssignableFrom(this.c)) {
            return new ConvertedLiteral(this, this.getAll(null), to);
        }
        Converter<T, R> p = Skript.getConverter(this.c, to);
        if (p == null) {
            return null;
        }
        Object[] parsedData = (Object[])Array.newInstance(to, this.data.length);
        int i = 0;
        while (i < this.data.length) {
            parsedData[i] = p.convert(this.data[i]);
            ++i;
        }
        return new ConvertedLiteral(this, parsedData, to);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "[" + this + "]";
    }

    @Override
    public String toString() {
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public boolean isSingle() {
        return !this.getAnd() || this.data.length <= 1;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }
}

