/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.intern.ConvertedExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.util.Validate;
import org.bukkit.event.Event;

public abstract class WrapperExpression<T>
extends SimpleExpression<T> {
    protected Expression<? extends T> expr;

    protected WrapperExpression() {
    }

    public WrapperExpression(SimpleExpression<? extends T> var) {
        Validate.notNull(var);
        this.expr = var;
    }

    @Override
    protected <R> ConvertedExpression<T, ? extends R> getConvertedExpr(Class<R> to) {
        Converter<T, R> conv = Skript.getConverter(this.getReturnType(), to);
        if (conv == null) {
            return null;
        }
        return new ConvertedExpression<T, R>(this.expr, to, conv){

            @Override
            public String getDebugMessage(Event e) {
                return "{" + WrapperExpression.this.getDebugMessage(e) + "}->" + this.to.getName();
            }
        };
    }

    @Override
    protected T[] getAll(Event e) {
        return this.expr.getArray(e);
    }

    @Override
    public boolean isSingle() {
        return this.expr.isSingle();
    }

    @Override
    public void setAnd(boolean and) {
        super.setAnd(and);
        this.expr.setAnd(and);
    }

    @Override
    public boolean getAnd() {
        return this.expr.getAnd();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return this.expr.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        this.expr.change(e, delta, mode);
    }

    @Override
    public String toString() {
        return this.expr.toString();
    }

    @Override
    public boolean setTime(int time) {
        return this.expr.setTime(time);
    }

    @Override
    public int getTime() {
        return this.expr.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.expr.isDefault();
    }
}

