/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.DefaultExpression;
import ch.njol.skript.api.Getter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    private final Class<T> c;
    private final T[] one;
    private final Changer<T, ?> changer;
    private final Map<Class<? extends Event>, Getter<? extends T, ?>> getters = new HashMap();

    public EventValueExpression(Class<T> c) {
        this(c, null);
    }

    public EventValueExpression(Class<T> c, Changer<T, ?> changer) {
        this.c = c;
        this.one = (Object[])Array.newInstance(c, 1);
        this.changer = changer;
    }

    @Override
    protected T[] getAll(Event e) {
        this.one[0] = this.getValue(e);
        if (this.one[0] == null) {
            return null;
        }
        return this.one;
    }

    private <E extends Event> T getValue(E e) {
        Getter<T, ?> g = this.getters.get(e.getClass());
        if (g != null) {
            return g.get(e);
        }
        for (Map.Entry<Class<Event>, Getter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(e.getClass())) continue;
            return p.getValue().get(e);
        }
        return null;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        return this.init();
    }

    @Override
    public boolean init() {
        boolean hasValue = false;
        Class<? extends Event>[] classArray = TriggerFileLoader.currentEvents;
        int n = TriggerFileLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (this.getters.containsKey(e)) {
                hasValue = true;
            } else {
                Getter<T, ? extends Event> getter = Skript.getEventValueGetter(e, this.c, this.getTime());
                if (getter != null) {
                    this.getters.put(e, getter);
                    hasValue = true;
                }
            }
            ++n2;
        }
        if (!hasValue) {
            Skript.error("There's no " + Skript.getExactClassName(this.c) + " in this event");
            return false;
        }
        return true;
    }

    @Override
    public Class<T> getReturnType() {
        return this.c;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "event-" + Skript.getExactClassName(this.c);
        }
        return Skript.getDebugMessage(this.getValue(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (this.changer == null) {
            return null;
        }
        return this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new UnsupportedOperationException();
        }
        Changer.ChangerUtils.change(this.changer, this.getArray(e), delta, mode);
    }

    @Override
    public String toString() {
        return "event-" + Skript.getExactClassName(this.c);
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] classArray = TriggerFileLoader.currentEvents;
        int n = TriggerFileLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (Skript.doesEventValueHaveTimeStates(e, this.c)) {
                super.setTime(time);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

