/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.Utils;
import java.util.ArrayList;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class ExprTarget
extends SimpleExpression<Entity> {
    private Expression<EntityType> types;
    private Expression<LivingEntity> entities;

    static {
        Skript.registerExpression(ExprTarget.class, Entity.class, "[the] target[[ed] %entitytypes%] [of %livingentities%]", "%livingentities%'[s] target[[ed] %entitytypes%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = vars[matchedPattern];
        this.entities = vars[1 - matchedPattern];
        return true;
    }

    protected Entity[] getAll(Event evt) {
        ArrayList<Entity> targets = new ArrayList<Entity>();
        EntityType[] types = this.types.getArray(evt);
        LivingEntity[] livingEntityArray = this.entities.getArray(evt);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity e = livingEntityArray[n2];
            EntityType[] entityTypeArray = types;
            int n3 = types.length;
            int n4 = 0;
            while (n4 < n3) {
                EntityType type = entityTypeArray[n4];
                Entity t = Utils.getTargetEntity(e, type.c);
                if (t != null) {
                    targets.add(t);
                }
                ++n4;
            }
            ++n2;
        }
        return targets.toArray(new Entity[0]);
    }

    @Override
    public Class<Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "targeted " + this.types.getDebugMessage(e) + " of " + this.entities.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return LivingEntity.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        LivingEntity target = (LivingEntity)delta;
        LivingEntity[] livingEntityArray = this.entities.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity entity = livingEntityArray[n2];
            if (entity instanceof Creature) {
                ((Creature)entity).setTarget(target);
            }
            ++n2;
        }
    }

    @Override
    public String toString() {
        return "the targeted " + this.types + " of " + this.entities;
    }

    @Override
    public boolean isSingle() {
        return this.entities.isSingle();
    }
}

