/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.LoopExpr;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class ExprLoopValue
extends WrapperExpression<Object> {
    private String name;

    static {
        Skript.registerExpression(ExprLoopValue.class, Object.class, "[the] loop-<\\S+>");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.name = parser.expr;
        String s = parser.regexes.get(0).group();
        int i = 1;
        Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(s);
        if (m.matches()) {
            s = m.group(1);
            i = Integer.parseInt(m.group(2));
        }
        for (LoopExpr<?> v : TriggerFileLoader.currentLoops) {
            if (!v.isLoopOf(s)) continue;
            if (i > 1) {
                --i;
                continue;
            }
            this.expr = v;
            return true;
        }
        Skript.error("there's no loop that matches " + this.name);
        return false;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return this.name;
        }
        return this.expr.getDebugMessage(e);
    }
}

