/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import java.util.ArrayList;
import org.bukkit.event.Event;

public class ExprIdOf
extends SimpleExpression<Integer> {
    private Expression<ItemType> types;
    private boolean single = false;

    static {
        Skript.registerExpression(ExprIdOf.class, Integer.class, "[the] id[<s>] of %itemtype%", "%itemtype%'[s] id[<s>]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = vars[0];
        if (parser.regexes.isEmpty()) {
            this.single = true;
            if (!this.types.isSingle() || this.types instanceof Literal && ((ItemType)((Literal)this.types).getSingle()).getTypes().size() != 1) {
                Skript.warning("'" + this.types + "' has multiple ids");
                this.single = false;
            }
        }
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "id" + (this.single ? "" : "s") + " of " + this.types.getDebugMessage(e);
    }

    protected Integer[] getAll(Event e) {
        if (this.single) {
            ItemType t = this.types.getSingle(e);
            if (t == null) {
                return null;
            }
            return new Integer[]{t.getTypes().get(0).getId()};
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        ItemType[] itemTypeArray = this.types.getArray(e);
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            for (ItemData d : t) {
                r.add(d.getId());
            }
            ++n2;
        }
        return r.toArray(new Integer[0]);
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString() {
        return "the ids of " + this.types;
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }
}

