/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class ExprFoodLevel
extends SimpleExpression<Integer> {
    private Expression<Player> players;

    static {
        Skript.registerExpression(ExprFoodLevel.class, Integer.class, "[the] food[[ ](level|meter)] [of %player%]", "%player%'[s] food[[ ](level|meter)]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "food level of " + this.players.getDebugMessage(e);
    }

    protected Integer[] getAll(Event e) {
        if (this.getTime() >= 0 && this.players.isDefault()) {
            return new Integer[]{((FoodLevelChangeEvent)e).getFoodLevel()};
        }
        return this.players.getArray(e, Integer.class, new Getter<Integer, Player>(){

            @Override
            public Integer get(Player p) {
                return p.getFoodLevel();
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return Integer.class;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int s = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            s = (Integer)delta;
        }
        switch (mode) {
            case SET: 
            case CLEAR: {
                if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent) {
                    ((FoodLevelChangeEvent)e).setFoodLevel(s);
                    return;
                }
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.setFoodLevel(s);
                    ++n2;
                }
                return;
            }
            case ADD: {
                if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent) {
                    ((FoodLevelChangeEvent)e).setFoodLevel(((FoodLevelChangeEvent)e).getFoodLevel() + s);
                    return;
                }
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    player.setFoodLevel(player.getFoodLevel() + s);
                    ++n3;
                }
                return;
            }
            case REMOVE: {
                if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent) {
                    ((FoodLevelChangeEvent)e).setFoodLevel(Math.max(((FoodLevelChangeEvent)e).getFoodLevel() - s, 0));
                    return;
                }
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player player = playerArray[n4];
                    player.setFoodLevel(Math.max(player.getFoodLevel() - s, 0));
                    ++n4;
                }
                return;
            }
        }
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString() {
        return "the food level of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, FoodLevelChangeEvent.class, this.players);
    }
}

