/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class ExprDistance
extends SimpleExpression<Double> {
    private Expression<Location> loc1;
    private Expression<Location> loc2;

    static {
        Skript.registerExpression(ExprDistance.class, Double.class, "distance between %location% and %location%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.loc1 = vars[0];
        this.loc2 = vars[1];
        return true;
    }

    protected Double[] getAll(Event e) {
        Location l1 = this.loc1.getSingle(e);
        Location l2 = this.loc2.getSingle(e);
        if (l1 == null || l2 == null || l1.getWorld() != l2.getWorld()) {
            return null;
        }
        return new Double[]{l1.distance(l2)};
    }

    @Override
    public String toString() {
        return "distance between " + this.loc1 + " and " + this.loc2;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "distance between " + this.loc1.getDebugMessage(e) + " and " + this.loc2.getDebugMessage(e);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }
}

