/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.BlockStateBlock;
import ch.njol.skript.util.Offset;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;

public class ExprBlock
extends SimpleExpression<Block> {
    private Expression<Offset> offsets;
    private Expression<Block> blocks;

    static {
        Skript.registerExpression(ExprBlock.class, Block.class, "[the] block[[s] %-offsets% [%blocks%]]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.offsets = vars[0];
        this.blocks = vars[1];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (this.offsets == null) {
            return this.blocks.getDebugMessage(e);
        }
        return "block" + (this.isSingle() ? "" : "s") + " " + this.offsets.getDebugMessage(e) + " " + this.blocks.getDebugMessage(e);
    }

    protected Block[] getAll(Event e) {
        Block[] bs;
        Block[] blockArray;
        BlockStateBlock b = null;
        if (this.blocks.isDefault()) {
            if (e instanceof BlockBreakEvent && this.getTime() == 1) {
                if (((BlockBreakEvent)e).getBlock().getType() == Material.ICE) {
                    BlockState s = ((BlockBreakEvent)e).getBlock().getState();
                    s.setType(Material.STATIONARY_WATER);
                    b = new BlockStateBlock(s);
                }
            } else if (e instanceof BlockPlaceEvent && this.getTime() == -1) {
                b = new BlockStateBlock(((BlockPlaceEvent)e).getBlockReplacedState());
            } else if (e instanceof BlockFadeEvent && this.getTime() == 1) {
                b = new BlockStateBlock(((BlockFadeEvent)e).getNewState());
            } else if (e instanceof BlockFormEvent && !(e instanceof BlockSpreadEvent) && this.getTime() >= 0) {
                b = new BlockStateBlock(((BlockFormEvent)e).getNewState());
            }
        }
        if (b != null) {
            Block[] blockArray2 = new Block[1];
            blockArray = blockArray2;
            blockArray2[0] = b;
        } else {
            blockArray = bs = this.blocks.getArray(e);
        }
        if (this.offsets == null) {
            return bs;
        }
        return Offset.setOff(this.offsets.getArray(e), bs);
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public String toString() {
        if (this.offsets == null) {
            return "the block";
        }
        return "the block" + (this.isSingle() ? "" : "s") + " " + this.offsets + " " + this.blocks;
    }

    @Override
    public boolean isSingle() {
        return (this.offsets == null || this.offsets.isSingle()) && this.blocks.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.blocks, BlockPlaceEvent.class, BlockBreakEvent.class, BlockFormEvent.class, BlockFadeEvent.class);
    }

    @Override
    public boolean isDefault() {
        return this.offsets == null;
    }
}

