/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ExprAttacker
extends SimpleExpression<Attacker> {
    static {
        Skript.registerExpression(ExprAttacker.class, Attacker.class, "[the] (attacker|damager)");
        Skript.registerConverter(Attacker.class, Entity.class, new Converter<Attacker, Entity>(){

            @Override
            public Entity convert(Attacker a) {
                if (a.getAttacker() instanceof Entity) {
                    return (Entity)a.getAttacker();
                }
                return null;
            }
        });
        Skript.registerConverter(Attacker.class, Block.class, new Converter<Attacker, Block>(){

            @Override
            public Block convert(Attacker a) {
                if (a.getAttacker() instanceof Block) {
                    return (Block)a.getAttacker();
                }
                return null;
            }
        });
        Skript.registerConverter(Attacker.class, Inventory.class, new Converter<Attacker, Inventory>(){

            @Override
            public Inventory convert(Attacker a) {
                if (a.getAttacker() instanceof Block) {
                    BlockState state = ((Block)a.getAttacker()).getState();
                    if (state instanceof InventoryHolder) {
                        return ((InventoryHolder)state).getInventory();
                    }
                } else if (a.getAttacker() instanceof InventoryHolder) {
                    return ((InventoryHolder)a.getAttacker()).getInventory();
                }
                return null;
            }
        });
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        return true;
    }

    protected Attacker[] getAll(Event e) {
        return new Attacker[]{new Attacker(ExprAttacker.getAttacker(e))};
    }

    private static Object getAttacker(Event e) {
        if (e instanceof EntityDamageByEntityEvent) {
            if (((EntityDamageByEntityEvent)e).getDamager() instanceof Projectile) {
                return ((Projectile)((EntityDamageByEntityEvent)e).getDamager()).getShooter();
            }
            return ((EntityDamageByEntityEvent)e).getDamager();
        }
        if (e instanceof EntityDamageByBlockEvent) {
            return ((EntityDamageByBlockEvent)e).getDamager();
        }
        if (e instanceof EntityDeathEvent) {
            return ExprAttacker.getAttacker((Event)((EntityDeathEvent)e).getEntity().getLastDamageCause());
        }
        if (e instanceof VehicleDamageEvent) {
            return ((VehicleDamageEvent)e).getAttacker();
        }
        if (e instanceof VehicleDestroyEvent) {
            return ((VehicleDestroyEvent)e).getAttacker();
        }
        return null;
    }

    @Override
    public Class<? extends Attacker> getReturnType() {
        return Attacker.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "attacker";
        }
        return Skript.getDebugMessage(this.getSingle(e) == null ? null : ((Attacker)this.getSingle(e)).attacker);
    }

    @Override
    public String toString() {
        return "the attacker";
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    public static final class Attacker {
        private final Object attacker;

        public Attacker(Object attacker) {
            this.attacker = attacker;
        }

        public Object getAttacker() {
            return this.attacker;
        }

        public String toString() {
            return Skript.toString(this.attacker);
        }
    }
}

