/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.PlayerSlot;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprArmorSlot
extends SimpleExpression<Slot> {
    private Expression<Player> players;
    private int slot;
    private static final String[] slotNames;

    static {
        Skript.registerExpression(ExprArmorSlot.class, Slot.class, "[the] (boot[s]|shoe[s]) [slot] of %players%", "%player%'[s] (boot[s]|shoe[s])", "[the] leg[ging]s [slot] of %players%", "%player%'[s] leg[ging]s", "[the] chestplate [slot] of %players%", "%player%'[s] chestplate", "[the] helm[et] [slot] of %players%", "%player%'[s] helm[et]");
        slotNames = new String[]{"boots", "leggings", "chestplate", "helmet"};
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.slot = matchedPattern / 2;
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return String.valueOf(slotNames[this.slot]) + " of " + this.players.getDebugMessage(e);
    }

    protected Slot[] getAll(Event e) {
        return this.players.getArray(e, Slot.class, new Converter<Player, Slot>(){

            @Override
            public Slot convert(final Player p) {
                return new PlayerSlot(p.getInventory()){

                    @Override
                    public ItemStack getItem() {
                        return p.getInventory().getArmorContents()[ExprArmorSlot.this.slot];
                    }

                    @Override
                    public void setItem(ItemStack item) {
                        ItemStack[] armour = p.getInventory().getArmorContents();
                        armour[((ExprArmorSlot)(this).ExprArmorSlot.this).slot] = item;
                        p.getInventory().setArmorContents(armour);
                    }

                    @Override
                    public String getDebugMessage(Event e) {
                        return String.valueOf(slotNames[ExprArmorSlot.this.slot]) + " of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public String toString() {
        return String.valueOf(slotNames[this.slot]) + " of " + this.players;
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public boolean isSingle() {
        return true;
    }
}

