/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.intern.TriggerSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.event.Event;

public class EffExit
extends Effect {
    private int breakLevels;

    static {
        Skript.registerEffect(EffExit.class, "(exit|stop) [trigger]", "(exit|stop) [1] section", "(exit|stop) <\\d+> sections", "(exit|stop) all sections");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: {
                this.breakLevels = TriggerFileLoader.currentSections.size() + 1;
                break;
            }
            case 1: {
                this.breakLevels = 1;
                break;
            }
            case 2: {
                this.breakLevels = Integer.parseInt(parser.regexes.get(0).group());
                if (this.breakLevels <= TriggerFileLoader.currentSections.size()) break;
                if (TriggerFileLoader.currentSections.isEmpty()) {
                    Skript.error("you can't exit any sections as there are no sections present");
                    return false;
                }
                Skript.error("you can't exit as there are only " + TriggerFileLoader.currentSections.size() + " sections present");
                return false;
            }
            case 3: {
                this.breakLevels = TriggerFileLoader.currentSections.size();
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        TriggerSection item = this.getParent();
        int i = 0;
        while (i < this.breakLevels && item != null) {
            item.stop();
            item = item.getParent();
            ++i;
        }
    }

    @Override
    public String getDebugMessage(Event e) {
        return "exit " + this.breakLevels + " sections";
    }
}

