/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Effect;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.util.Patterns;
import org.bukkit.event.Event;

public class EffChange
extends Effect {
    private static Patterns<Changer.ChangeMode> patterns = new Patterns(new Object[][]{{"(add|give) %objects% to %objects%", Changer.ChangeMode.ADD}, {"give %objects% %objects%", Changer.ChangeMode.ADD}, {"set %objects% to %objects%", Changer.ChangeMode.SET}, {"remove %objects% from %objects%", Changer.ChangeMode.REMOVE}, {"(clear|delete) %objects%", Changer.ChangeMode.CLEAR}});
    private Expression<?> changed;
    private Expression<?> changer = null;
    private Changer.ChangeMode mode;
    private boolean single = true;
    private Changer<?, ?> c = null;

    static {
        Skript.registerEffect(EffChange.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.mode = patterns.getInfo(matchedPattern);
        switch (this.mode) {
            case ADD: {
                if (matchedPattern == 0) {
                    this.changer = vars[0];
                    this.changed = vars[1];
                    break;
                }
                this.changer = vars[1];
                this.changed = vars[0];
                break;
            }
            case SET: {
                this.changer = vars[1];
                this.changed = vars[0];
                break;
            }
            case REMOVE: {
                this.changer = vars[0];
                this.changed = vars[1];
                break;
            }
            case CLEAR: {
                this.changed = vars[0];
            }
        }
        if (this.changed instanceof UnparsedLiteral) {
            return false;
        }
        Class<?> r = this.changed.acceptChange(this.mode);
        if (r == null) {
            ClassInfo<?> ci = Skript.getSuperClassInfo(this.changed.getReturnType());
            if (ci == null || ci.getChanger() == null || ci.getChanger().acceptChange(this.mode) == null) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can't be set");
                } else if (this.mode == Changer.ChangeMode.CLEAR) {
                    Skript.error(this.changed + " can't be cleared/deleted");
                } else {
                    Skript.error(this.changed + " can't have something " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " it");
                }
                return false;
            }
            this.c = ci.getChanger();
            r = this.c.acceptChange(this.mode);
        }
        if (r.isArray()) {
            this.single = false;
            r = r.getComponentType();
        }
        if (this.changer != null) {
            Expression<?> v = this.changer.getConvertedExpression(r);
            if (v == null) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can't be set to " + this.changer);
                } else {
                    Skript.error(this.changer + " can't be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed);
                }
                return false;
            }
            this.changer = v;
            if (!this.changer.isSingle() && this.single) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can only be set to one " + Skript.getExactClassName(r) + ", but multiple are given");
                } else {
                    Skript.error("only one " + Skript.getExactClassName(r) + " can be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + ", but multiple are given");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.c != null) {
            Changer.ChangerUtils.change(this.c, this.changed.getArray(e), this.changer == null ? null : (this.single ? (?[])this.changer.getSingle(e) : this.changer.getArray(e)), this.mode);
        } else {
            this.changed.change(e, this.changer == null ? null : (this.single ? (?[])this.changer.getSingle(e) : this.changer.getArray(e)), this.mode);
        }
    }

    @Override
    public String getDebugMessage(Event e) {
        switch (this.mode) {
            case ADD: {
                return "add " + this.changer.getDebugMessage(e) + " to " + this.changed.getDebugMessage(null);
            }
            case CLEAR: {
                return "clear " + this.changed.getDebugMessage(null);
            }
            case REMOVE: {
                return "remove " + this.changer.getDebugMessage(e) + " from " + this.changed.getDebugMessage(null);
            }
            case SET: {
                return "set " + this.changed.getDebugMessage(e) + " to " + this.changer.getDebugMessage(null);
            }
        }
        throw new IllegalStateException();
    }
}

