/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.Verbosity;
import ch.njol.skript.api.SimpleEvent;
import ch.njol.skript.api.intern.Trigger;
import ch.njol.skript.api.intern.TriggerItem;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.util.Utils;
import ch.njol.util.Validate;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;

public class SkriptCommand {
    private final Trigger trigger;
    private final List<Argument<?>> arguments;
    final String name;
    final String description;
    final String usageMessage;
    final Collection<String> aliases;
    final String permission;
    final String permissionMessage;

    public SkriptCommand(String name, List<Argument<?>> arguments, String description, String usageMessage, Collection<String> aliases, String permission, String permissionMessage, List<TriggerItem> items) {
        Validate.notNull(name, arguments, description, usageMessage, aliases, items);
        this.name = name;
        this.description = description;
        this.usageMessage = usageMessage;
        this.aliases = aliases;
        this.trigger = new Trigger("command /" + name, new SimpleEvent(), items);
        this.permission = permission;
        this.permissionMessage = permissionMessage == null ? "You don't have the required permission to use this command" : permissionMessage;
        this.arguments = arguments;
    }

    public boolean execute(CommandSender sender, String commandLabel, String rest) {
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            sender.sendMessage(this.permissionMessage);
            return false;
        }
        String[] args = rest.split("\\s*,\\s*");
        if (args.length == 1 && args[0].isEmpty()) {
            args = new String[]{};
        }
        SkriptCommandEvent event = new SkriptCommandEvent(this, sender, args);
        int i = 0;
        while (i < this.arguments.size()) {
            Argument<?> a = this.arguments.get(i);
            if (i < args.length) {
                if (a.isSingle() ? !a.parse(args[i], sender) : !a.parse(args, i, sender)) {
                    return false;
                }
            } else {
                a.setToDefault(event);
            }
            ++i;
        }
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# /" + this.name + " " + Utils.join(args, ", "));
        }
        long startTrigger = System.nanoTime();
        this.trigger.run(event);
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# " + this.name + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
        }
        return true;
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }
}

