/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.api.Changer;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultChangers {
    public static final Changer<World, Object> timeChanger = new Changer<World, Object>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: 
                case REMOVE: {
                    return Timespan.class;
                }
                case SET: {
                    return Time.class;
                }
            }
            return null;
        }

        public void change(World[] worlds, Object delta, Changer.ChangeMode mode) {
            int mod = 1;
            switch (mode) {
                case SET: {
                    Time time = (Time)delta;
                    World[] worldArray = worlds;
                    int n = worlds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        World w = worldArray[n2];
                        w.setTime((long)time.getTicks());
                        ++n2;
                    }
                    break;
                }
                case REMOVE: {
                    mod = -1;
                }
                case ADD: {
                    Timespan ts = (Timespan)delta;
                    World[] worldArray = worlds;
                    int n = worlds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        World w = worldArray[n3];
                        w.setTime(w.getTime() + (long)(mod * ts.getTicks()));
                        ++n3;
                    }
                    break;
                }
            }
        }
    };
    public static final Changer<Inventory, ItemType[]> inventoryChanger = new Changer<Inventory, ItemType[]>(){

        @Override
        public Class<ItemType[]> acceptChange(Changer.ChangeMode mode) {
            return ItemType[].class;
        }

        public void change(Inventory[] invis, ItemType[] delta, Changer.ChangeMode mode) {
            Inventory[] inventoryArray = invis;
            int n = invis.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory invi = inventoryArray[n2];
                switch (mode) {
                    case SET: 
                    case CLEAR: {
                        invi.clear();
                        if (invi instanceof PlayerInventory) {
                            ((PlayerInventory)invi).setArmorContents(new ItemStack[4]);
                        }
                        if (mode == Changer.ChangeMode.CLEAR) break;
                    }
                    case ADD: {
                        ItemType type;
                        ItemType[] itemTypeArray = delta;
                        int n3 = delta.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.addTo(invi);
                            ++n4;
                        }
                        break;
                    }
                    case REMOVE: {
                        ItemType type;
                        ItemType[] itemTypeArray = delta;
                        int n3 = delta.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.removeFrom(invi);
                            ++n4;
                        }
                        break;
                    }
                }
                if (invi instanceof PlayerInventory) {
                    ((Player)invi.getHolder()).updateInventory();
                }
                ++n2;
            }
        }
    };
}

